c                                                                       
c Plot seismograms generated by 'rz' or 'rw'.                            
c A Calcomp-type plotting library is required.                            
c                                                                       
      dimension r(30),t(30),amw(4096)                                   
c
      xo = 2.
c       initial plotting point
      read (5,*) strt                                                   
c       amplitude factor
      read (5,*) afct                                                   
c       time factor
      read (5,*) tfct                                                   
c       distance factor
      read (5,*) rfct                                                   
c                                                                       
c graphics initialization (mainframe)
c     call device('xyplot  ', id, id, id, idi)                          
c     call rwind(0, 0, 180*80, 250*80)                                  
c     call vsini(0., 0., 18., 25.)                                      
c graphics initialization (calpak)
      call hplots(1, 1, 8, 0)
      open(15, file='fort.10')
c         dt(time step), vred(reduction velocity)                       
      read(15,'(2g12.5)') dt,vred                                       
c         nent(# of seismograms)                                        
      read(15,'(i5)'    ) nent                                          
c                                                                       
      do 40 kr=1,nent                                                   
c             r(distance), t(initial time)                              
          read(15,'(2f12.5)') r(kr),t(kr)                               
c             ndr(# of data ponits)                                     
          read(15,'(i5)'    ) ndr                                       
c             amax(maximum amplitude)                                   
          read(15,'(g15.7)' ) amax                                      
c             amw(normalized seismograms)                               
          read(15,'(6f12.7)') (amw(i),i=1,ndr)                          
c                                                                       
          if(kr .ne. 1) then                                            
              if(r(kr) .eq. r(1)) then
                  strt = strt - abs(afct)*2.0
              else
                  strt = strt - rfct*(r(kr)-r(kr-1))                        
              endif
          else                                                          
              if(afct .lt. 0.)  amx1 = amax                             
          endif
c          call plot(xo, strt, 3)
          iplot = 3
          do 135 i=1,ndr                                                
              x = (i-1)*dt*tfct + xo
              if(afct .ge. 0.) then                                     
                  y = amw(i)*afct + strt                                
              else                                                      
c                  y = amw(i)*amax/amx1*abs(afct) + strt                 
                  y = amw(i)*amax/amx1*afct + strt                 
              endif                                                     
c              call plot(x, y, 2)
              call plot(x, y, iplot)
              if(iplot .eq. 3) iplot = 2
  135     continue                                                      
   40 continue                                                          
c                                                                       
c graphics termination (mainframe)
c     call vsterm(0,0)                                                  
c     call gpsltm                                                       
c graphics termination (calpak)
      call hplots(0, 0, 8, 0)
      stop                                                              
      end                                                               
