C*********************************************************************  
C*   EXTENDED REFLECTIVITY METHOD (FINITE FAULT)                     *  
C*            1. ATTENUATIVE LAYERED HALFSPACE                       *  
C*            2. A PROPAGATING FAULT                                 *  
C*            3. NO STATIC OFFSET                                    *  
C*            4. ESSENTIALLY BASED ON RZ (POINT SOURCE VERSION)      *  
C*                                                                   *  
C*<MODIFICATION HISTORY>                                             *  
C*  08/24/84  ORIGINAL                                               *  
C*  11/07/86  A SOURCE CAN BE LOCATED AT ANY DEPTH.                  *  
C*  10/26/25  double precision, Bessel functions from Netlib and     *
C*            machine.f90                                            *  
C* <INPUT DATA>                                                      *  
C*  ALL PARAMETERS ARE REQUIRED WITHOUT EXCEPTION.   BUT MEANINGLESS *  
C*  PARMS.(INSTRUMENTS OF HERRMANN'S F) CAN BE SPECIFIED WITH BLANKS.*  
C*  DEP     ; DEPTH OF THE UPPER FAULT BORDER                        *  
C*  IOPT    ; 1-INTEGRATED, 2-AS IS, 3-DIFFERENTIATED                *  
C*  ILTR    ; 1-UNILATERAL,2-BILATERAL                               *  
C*  ISRC    ; 0-HERRMANN, 1-RAMP F.+INSTRUMENT                       *  
C*          ; 3 SEISMOGRAMS(NS, EW, VERTICAL) ARE ALWAYS GENERATED.  *  
C*  RR      ; EPICENTRAL DISTANCE                                    *  
C*  ATH     ; OBSERVER AZIMUTH FROM FAULT STRIKE                     *  
C*  AST     ; FAULT STRIKE FROM NORTH                                *  
C*  DISL    ; AVERAGE DISLOCATION                                    *  
C*  ADP     ; DIP ANGLE                                              *  
C*  ASD     ; SLIP DIRECTION                                         *  
C*  TC(1-3) ; NATURAL PERIOD OF SEISMOGRAPH (R, T, Z)                *  
C*  HC(1-3) ; DAMPING FACTOR OF SEISMOGRAPH (R, T, Z)                *  
C*  VC(1-3) ; STATIC MAGNIFICATION OF SEISMOGRAPH (R, T, Z)          *  
C*  SL,SW   ; FAULT LENGTH AND WIDTH                                 *  
C*  VL      ; RUPTURE VELOCITY                                       *  
C*  NL,NW   ; EVALUATION POINTS OF FAULT INTEGRAL ALONG 'SL' OR 'SW' *  
C*  FU,FO   ; U. & L. LIMITS OF FREQUENCY WINDOW                     *  
C* ALIM,BLIM; U. & L. LIMITS OF PHASE VELOCITY WINDOW                *  
C*  DK      ; STEP SIZE OF WAVENUMBER INTEGRAL                       *  
C*  INDEX   ; EXP. FACTOR OF NO. OF TIME POINTS (2**INDEX)           *  
C*  WI      ; IMAGINARY PART OF FREQUENCY                            *  
C*  VRED    ; VELOCITY OF REDUCTION                                  *  
C*  TI,TL   ; L. & U. LIMITS OF TIME WINDOW                          *  
C*  DT      ; TIME INCREMENT                                         *  
C*  TS      ; PARAMETER OF SOURCE TIME FUNCTION (RISE TIME)          *  
C*  THN(I)  ; THICKNESS OF LAYER (ENDED BY 0.)                       *  
C*  VP,VS(I); P- AND S-VELOCITIES                                    *  
C*  RHO(I)  ; DENSITY                                                *  
C*  QP,QS(I); Q-VALUES FOR P- AND S-WAVES                            *  
C*********************************************************************  
      implicit real*8 (a-h, o-z)
      COMMON /LYR/ CP,CS,RHO,THN,BP,BS,RH,D                             
      DIMENSION  D(50),THN(50),VP(50),VS(50),RHO(50),RH(50)             
     *          ,QP(50),QS(50),AMW(2048),TC(3),HC(3),VC(3)              
     *          ,R(100)  ,BRJ0(100),BRJ1(100),SST(100),CST(100)           
     *          ,PV0(100),PV1(100),PV2(100),SH1(100),SH2(100)           
     *          ,DL02(100),DL04(100),DL11(100),DL24(100)                
     *          ,DS11(100),DS22(100),VB2(100)                           
      COMPLEX*16 TD,AI,PW(2048,3),DUM(4096),S(2048,3)                   
     *          ,CP(50),CS(50),BP(50),BS(50),UW(10,100)                 
     *          ,W1,W2,W3,PX1,PX2,PX3,PY1,PY2,PY3                       
     *          ,DL02,DL04,DL11,DL24,DS11,DS22,VB2                      
     *          ,FRQ,OMEG,OMEG2,U,BR,AK2,BK2                            
c      REAL*8       DX0                                                  
      CHARACTER*12 CHARAC,TYPE                                          
      DATA AI/(0.,1.)/,PI2/6.283185/                                    
C                                                                       
c         (allow overflows on a mainframe)
c      call errset(207, 256, 0, 0, 0)                                  
C                                                                       
C   INPUT                                                               
C                                                                       
  500 FORMAT(5I5)                                                       
  505 FORMAT(F5.0,3I5)                                                  
  510 FORMAT(7G10.3)                                                    
      READ(5,505) DEP,IOPT,ILTR,ISRC                                    
      READ(5,510) RR,ATH,AST                                            
C***** ATH = OBSERVER AZIMUTH FROM FAULT STRIKE *****                   
C***** AST = FAULT STRIKE FROM NORTH            *****                   
      READ(5,510) DISL,ADP,ASD                                          
      DO 12 I=1,3                                                       
   12 READ(5,510) TC(I),HC(I),VC(I)                                     
      READ(5,510) SL,SW,VL                                              
      READ(5,500) NL,NW                                                 
      READ(5,510) FU,FO                                                 
      READ(5,510) ALIM,BLIM,DK                                          
      READ(5,500) INDEX                                                 
      READ(5,510) WI                                                    
      READ(5,510) VRED,TI,TL                                            
      READ(5,510) DT,TS                                                 
C******* LAYER PARAMETERS *******                                       
      DO 10 I=1,50                                                      
        NOL=I                                                           
        READ(5,510) THN(I),VP(I),VS(I),RHO(I),QP(I),QS(I)               
          IF(VS(I) .EQ.0.)     VS(I) = VP(I)/1.732051                   
          IF(RHO(I).EQ.0.)    RHO(I) = VP(I)*0.3788 + 0.252             
          IF(QP(I).NE.0. .AND. QS(I).EQ.0.) QS(I) = QP(I)*4./9.         
          IF(THN(I).EQ.0.)    GO TO 1000                                
   10 CONTINUE                                                          
 1000 DO 58 I=1,NOL                                                     
        CP(I) = VP(I)                                                   
        CS(I) = VS(I)                                                   
          IF(QP(I).NE.0.) CP(I) = VP(I)*(1.+AI/(2.*QP(I)))              
          IF(QS(I).NE.0.) CS(I) = VS(I)*(1.+AI/(2.*QS(I)))              
   58 CONTINUE                                                          
      DO 59 I=1,NOL                                                     
   59 D(I) = THN(I)                                                     
C******* TIME CONSTANTS *******                                         
      NPTS = 2**INDEX                                                   
      INPT = NPTS/2                                                     
      FNPT = NPTS                                                       
      DAUER = DT*(FNPT-1.)                                              
      DF    = 1./(DAUER+DT)                                             
      TR    = RR/VRED + TI                                              
C                                                                       
C   SOURCE                                                              
C                                                                       
      IF (ISRC .EQ. 1) GO TO 1400                                       
      WRITE(6,635) TS                                                   
  635 FORMAT(1H ,//,' HERRMANN-TYPE SOURCE (',F10.5,')')                
      DO 31 J=1,3                                                       
        DO 32 I=1,NPTS                                                  
          TT = DT*(I-1)/TS                                              
            IF(TT.LE.1.)                S(I,J) = TT*TT/2.               
            IF(TT.GT.1. .AND. TT.LE.3.) S(I,J) = -(TT-2.)*(TT-2.)/2.+1. 
            IF(TT.GT.3. .AND. TT.LE.4.) S(I,J) = (TT-4.)*(TT-4.)/2.     
            IF(TT.GT.4.)                S(I,J) = 0.                     
          S(I,J) = S(I,J)/(2.*TS)*EXP(-TT*TS*WI)                        
   32   CONTINUE                                                        
        CALL NLOGN(INDEX,S(1,J),-1.d0)                                   
   31 CONTINUE                                                          
      GO TO 1500                                                        
 1400 WRITE(6,636) TS                                                   
  636 FORMAT(1H ,//,' RAMP FUNCTION SOURCE (',F10.5,')')                
      WRITE(6,637) TC,HC,VC                                             
  637 FORMAT(' NATURAL PERIOD   ',3F10.5/
     *      ,' DAMPING COEFF.   ',3F10.5/
     *      ,' MAGNIFICATION    ',3F10.5/)                              
      DO 39 J=1,3                                                       
        CN   = PI2/TC(J)                                                
        DO 35 I=1,INPT                                                  
          OMEG  = CMPLX(DF*PI2*(I-1),-WI)                               
          OMEG2 = OMEG**2                                               
          S(I,J) = DISL/TS * (EXP(-AI*OMEG*TS)-1.)/OMEG**2 /DT          
     *         * VC(J)*OMEG2/(OMEG2-CN**2-2.*HC(J)*CN*OMEG*AI)          
   35   CONTINUE                                                        
   39 CONTINUE                                                          
C******* SURFACE INTEGRAL PARAMETER *****                               
 1500 DL = SL/(NL-1)                                                    
      NNL= NL                                                           
        IF(ILTR .EQ. 2) NNL = NL*2-1                                    
      DW = SW/(NW-1)                                                    
C                                                                       
C   SPECTRUM WINDOW                                                     
C                                                                       
      IU  = FU*DAUER+1.                                                 
      IO  = FO*DAUER+1.                                                 
      NFZ = IO-IU+1                                                     
C                                                                       
C   PARAMETER LIST                                                      
C                                                                       
      WRITE(6,600)                                                      
  600 FORMAT(1H ////,5X,'STRUCTURE'//,10X,'THICKNESS',5X,               
     1       'VP',9X,'VS',9X,'RHO',8X,'QP',9X,'QS')                     
      WRITE(6,605) (THN(I),VP(I),VS(I),RHO(I),QP(I),QS(I),I=1,NOL)      
  605 FORMAT(1H ,5X,F12.2,5F11.3)                                       
  610 FORMAT(1H0//,5X,'EPICENTRAL DISTANCE =')                          
      WRITE(6,610)                                                      
      WRITE(6,626) RR                                                   
  626 FORMAT(7G10.3)                                                    
      WRITE(6,611)  DEP,WI,FU,FO,ALIM,BLIM,NFZ,DF,DK,TI,TL,VRED         
  611 FORMAT( 5X,'SOURCE DEPTH (KM)  =',F7.2/                           
     *      , 5X,'TIME ATTENUATION   =',F7.2/                           
     *      ,10X,'LIMITS OF INTEGRATION'/                               
     *      ,15X,'FREQUENCY   ',F7.2,' HZ--',F7.2,' HZ'/                
     *      ,15X,'PHASE VEL.   ',E8.3,' --',F7.3,' KM/S'/               
     *      ,10X,'DATA SIZE FOR INTEGRATION'/                           
     *      ,15X,'FREQUENCY   ',2X,I5,' (DF  =',E12.5,' HZ)'/           
     *      ,15X,'WAVE NUMBER ',7X   ,' (DK  =',E12.5,'   )'/           
     *      ,10X,'OUTPUT DURATION'/                                     
     *      ,27X,F7.2,'SEC--',F7.2,'SEC (',G7.2,' KM/S REDUCED)'/)      
      IF(IOPT.EQ.1) CHARAC= 'DIFFER.     '                              
      IF(IOPT.EQ.2) CHARAC= 'AS IS       '                              
      IF(IOPT.EQ.3) CHARAC= 'INTEGRATED  '                              
      IF(ILTR.EQ.1) TYPE  = 'UNI-LATERAL '                              
      IF(ILTR.EQ.2) TYPE  = 'BI -LATERAL '                              
      WRITE(6,638) CHARAC,TYPE                                          
  638 FORMAT(1H //,5X,A12/,5X,A12,'RUPTURE PROPAGATION')                
      WRITE(6,639) DISL,TS,ADP,SL,SW,DL,DW,NL,NW,VL                     
  639 FORMAT(10X,'AVERAGE DISLOCATION',E12.5/                           
     *      ,10X,'RISE TIME          ',F7.2/                            
     *      ,10X,'DIP    ANGLE       ',F7.2/                            
     *      ,10X,'LENGTH   ',F7.2,5X,'WIDTH    ',F7.2/                  
     *      ,10X,'D-LENGTH ',F7.2,5X,'D-WIDTH  ',F7.2/                  
     *      ,10X,'N-LENGTH ',I7  ,5X,'N-WIDTH  ',I7/                    
     *      ,10X,'RUPTURE VELOCITY',F7.2/)                              
      VLI = 0.                                                          
        IF (VL .EQ. 0.) GO TO 110                                       
      VLI = 1./VL                                                       
  110 CONTINUE                                                          
C                                                                       
C   ANGULAR CONSTANTS                                                   
C                                                                       
      ATH = ATH/360.*PI2                                                
      ADP = ADP/360.*PI2                                                
      ASD = ASD/360.*PI2                                                
      AST = AST/360.*PI2                                                
      SSD = SIN(ASD)                                                    
      CSD = COS(ASD)                                                    
      SDP = SIN(ADP)                                                    
      CDP = COS(ADP)                                                    
      CDP2= CDP**2-SDP**2                                               
      RX  = RR*COS(ATH)                                                 
      RY  = RR*SIN(ATH)                                                 
      DH  = DW*SDP                                                      
C                                                                       
C   LAYER EFFECT                                                        
C                                                                       
C*********** F-LOOP ***********                                         
 1700 DO 60 I=1,INPT                                                    
        DO 400 M=1,3                                                    
  400   PW(I,M) = 0.                                                    
        FJ = I-1                                                        
        RRQ = FJ/(DAUER+DT)                                             
          IF(I.LT.IU.OR.I.GT.IO) GO TO 60                               
        WRITE(6,653) RRQ,I                                              
          IF(RRQ    .EQ.     0.) GO TO 60                               
  653   FORMAT (F12.7,I7)                                               
        FRQ = CMPLX(RRQ,-WI/PI2)                                        
        OMER = RRQ*PI2                                                  
        OMEG = CMPLX(OMER,-WI)                                          
        SA   = OMER/ALIM                                                
        SB   = OMER/BLIM                                                
C       ENDIF                                                           
        NK   = (SB-SA)/DK+1                                             
C*********** K-LOOP ***********                                         
        DO 65 J=1,NK                                                    
          SK  = SA+(J-1)*DK                                             
          U   = SK/OMEG                                                 
          SK2 = SK*SK                                                   
          DO 410 L=1,NW                                                 
            CALL LAYER(DEP+DH*(L-1), NOL, NS)                           
            BR  = BS(NS+1)**2*RH(NS+1)                                  
            AK2 = (OMEG/BP(NS+1))**2                                    
            BK2 = (OMEG/BS(NS+1))**2                                    
            DL02(L) = 4.*SK*AK2                                         
            DL24(L) = (0.,2.)*SK2*BR                                    
            DL04(L) = DL24(L)*(4.*AK2-3.*BK2)                           
            DL11(L) = (0.,-2.)*SK*BK2                                   
            DL24(L) = -DL24(L)*BK2                                      
            DS11(L) = -2.*BK2                                           
            DS22(L) = -SK*BK2*BR                                        
            VB2(L)  = BS(NS+1)**2                                       
            CALL NPSVSH(NOL+1,NS,BP,BS,RH,D,U,FRQ,UW(1,L))              
  410     CONTINUE                                                      
C*********** X-LOOP ***********                                         
          PX1 = 0.                                                      
          PX2 = 0.                                                      
          PX3 = 0.                                                      
          DO 420 K=1,NNL                                                
            XL = DL*(K-1)                                               
              IF (ILTR .EQ. 2) XL = DL*(K-NL)                           
            TD = EXP(-AI*OMEG*ABS(XL)*VLI)                              
C*********** Y-LOOP ***********                                         
            PY1 = 0.                                                    
            PY2 = 0.                                                    
            PY3 = 0.                                                    
            DO 430 L=1,NW                                               
              YL  = DW*CDP*(L-1)                                        
              X   = RX - XL                                             
              Y   = RY - YL                                             
              R(L)= SQRT(X**2+Y**2)                                     
              BTH = ATAN2(Y,X)                                          
              STH = SIN(BTH)                                            
              CTH = COS(BTH)                                            
              STH2= 2.*STH*CTH                                          
              CTH2= CTH**2-STH**2                                       
              BST = BTH+AST                                             
              CST(L) = COS(BST)                                         
              SST(L) = SIN(BST)                                         
              PV0(L) = 0.5*SSD*2.*SDP*CDP                               
              PV1(L) = CSD*CDP*CTH-SSD*CDP2*STH                         
              PV2(L) = PV0(L)*CTH2+CSD*SDP*STH2                         
              SH1(L) =-CSD*CDP*STH-SSD*CDP2*CTH                         
              SH2(L) =-PV0(L)*2.*STH2+CSD*SDP*2.*CTH2                   
              RK = SK*R(L)                                              
              BRJ0(L) = besj0(rk)                                                
              BRJ1(L) = besj1(rk)                                               
  430       CONTINUE                                                    
            DO 435 L=1,NW                                               
              RK = R(L)*SK                                              
              BJ0 = BRJ0(L)                                              
              BJ1 = BRJ1(L)                                              
              DJ0 =-BJ1                                                 
              BJ2 = 2./RK*BJ1-BJ0                                       
              DJ1 = BJ0-BJ1/RK                                          
              DJ2 = BJ1-2./RK*BJ2                                       
              W1 = PV0(L)*(UW(2,L)*DL02(L)+UW(4,L)*DL04(L))*DJ0/AI      
     *            +PV1(L)*UW(1 ,L)*DL11(L)*DJ1/AI                       
     *            +PV2(L)*UW(4 ,L)*DL24(L)*DJ2/AI                       
     *            -PV1(L)*UW(9 ,L)*DS11(L)*BJ1/R(L)                     
     *            -PV2(L)*UW(10,L)*DS22(L)*4.*BJ2/R(L)                  
              W2 = SH1(L)*UW(1 ,L)*DL11(L)*BJ1/(AI*RK)                  
     *            +SH2(L)*UW(4 ,L)*DL24(L)*BJ2/(AI*RK)                  
     *            -SH1(L)*UW(9 ,L)*DS11(L)*DJ1*SK                       
     *            -SH2(L)*UW(10,L)*DS22(L)*DJ2*SK                       
              W3 = PV0(L)*(UW(6,L)*DL02(L)+UW(8,L)*DL04(L))*BJ0         
     *            +PV1(L)*UW(5 ,L)*DL11(L)*BJ1                          
     *            +PV2(L)*UW(8 ,L)*DL24(L)*BJ2                          
C VB2 IS A PART OF SOURCE SPECTRUM.                                     
              DDW = DW * VB2(L)                                         
                IF(L.EQ.1 .OR. L.EQ.NW) DDW = DW/2.                     
              PY1 = PY1 +(W1*CST(L)-W2*SST(L))*DDW                      
              PY2 = PY2 +(W1*SST(L)+W2*CST(L))*DDW                      
              PY3 = PY3 - W3*DDW                                        
  435       CONTINUE                                                    
            DDL = DL                                                    
              IF (K.EQ.1 .OR. K.EQ.NNL) DDL = DL/2.                     
            PX1 = PX1 + PY1*TD*DDL                                      
            PX2 = PX2 + PY2*TD*DDL                                      
            PX3 = PX3 - PY3*TD*DDL                                      
  420     CONTINUE                                                      
          DDK = DK                                                      
            IF (J.EQ.1 .OR. J.EQ.NK) DDK = DK/2.                        
          PW(I,1) = PW(I,1) +PX1*DDK                                    
          PW(I,2) = PW(I,2) +PX2*DDK                                    
          PW(I,3) = PW(I,3) +PX3*DDK                                    
   65   CONTINUE                                                        
        DO 440 M=1,3                                                    
          PW(I,M) = PW(I,M)*S(I,M)*EXP(AI*OMEG*TR)/(2.*PI2*OMEG*OMEG)  
  440   CONTINUE                                                        
   60 CONTINUE                                                          
C                                                                       
C   INVERSE-FFT                                                         
C                                                                       
      WRITE(10,654) DT,VRED                                             
  654 FORMAT (2G12.5)                                                   
      WRITE(10,*) '   3'                                                
      DO 70 M=1,3                                                       
        N1=INPT+1                                                       
        DUM(1) = PW(1,M)                                                
        DO 90 K=2,INPT                                                  
          NJ  =2*INPT-K+2                                               
          DUM(K) = PW(K,M)                                              
          DUM(NJ) = CONJG(PW(K,M))                                      
   90   CONTINUE                                                        
        DUM(N1) = 0.                                                    
        CALL NLOGN(INDEX,DUM,1.d0)                                       
        DO 125 I=1,NPTS                                                 
  125   PW(I,M)=DUM(I)                                                  
C                                                                       
C   OUTPUT                                                              
C                                                                       
        AMAX=0.                                                         
        NDR =(TL-TI)/DT                                                 
          IF(NPTS.LT.NDR) NDR = NPTS                                    
        DO 130 I=1,NDR                                                  
          TT = DT*FLOAT(I-1)                                            
          AMW(I)=REAL(PW(I,M))*EXP(WI*TT)                               
          AMA = ABS(AMW(I))                                             
          AMAX=MAX(AMAX,AMA)                                            
  130   CONTINUE                                                        
c        RC = RR + (M-1)                                                 
c        WRITE(10,699) RC,TR                                             
        WRITE(10,699) RR,TR                                             
        WRITE(10,500) NDR                                               
        WRITE(10,698) AMAX                                              
        DO 205 I=1,NDR                                                  
          AMW(I)=AMW(I)/AMAX                                            
205     CONTINUE                                                        
        WRITE(10,699) (AMW(I),I=1,NDR)                                  
   70 CONTINUE                                                          
699   FORMAT(6F12.7)                                                    
698   FORMAT(E15.7)                                                     
      STOP                                                              
      END                                                               
C                                                                       
      SUBROUTINE LAYER(DS, NOL, NS)                                     
C     REARRANGE LAYERS FOR A SOURCE                                     
      implicit real*8 (a-h, o-z)
      COMMON /LYR/ CP,CS,RHO,THN,BP,BS,RH,D                             
      COMPLEX*16   CP(50),CS(50),BP(50),BS(50)                          
      dimension    RHO(50),THN(50),RH(50),D(50)                         
C                                                                       
      S = 0.                                                            
      DO 10 I=1,NOL-1                                                   
        S = S + THN(I)                                                  
        IF(DS .LT. S) GO TO 200                                         
        IF(DS .EQ. S) THEN                                              
          WRITE(6,*) 'THE SOURCE IS LOCATED JUST ON A INTERFACE.'       
          STOP                                                          
        ENDIF                                                           
   10 CONTINUE                                                          
C SOURCE IS LOCATED IN THE HALFSPACE.                                   
      NS = NOL                                                          
      DO 20 J=1,NOL-1                                                   
        D(J)  = THN(J)                                                  
        BP(J) = CP(J)                                                   
        BS(J) = CS(J)                                                   
        RH(J) = RHO(J)                                                  
   20 CONTINUE                                                          
      D(NOL  )  = DS - S                                                
      BP(NOL  ) = CP(NOL)                                               
      BS(NOL  ) = CS(NOL)                                               
      RH(NOL  ) = RHO(NOL)                                              
      D(NOL+1)  = 0.                                                    
      BP(NOL+1) = CP(NOL)                                               
      BS(NOL+1) = CS(NOL)                                               
      RH(NOL+1) = RHO(NOL)                                              
      RETURN                                                            
C SOURCE IS LOCATED IN A LAYER.                                         
  200 NS = I                                                            
      IF(I .EQ. 1) THEN                                                 
        D(1)  = DS                                                      
        BP(1) = CP(1)                                                   
        BS(1) = CS(1)                                                   
        RH(1) = RHO(1)                                                  
        D(2)  = THN(1) - D(I)                                           
        BP(2) = CP(1)                                                   
        BS(2) = CS(1)                                                   
        RH(2) = RHO(1)                                                  
      ELSE                                                              
        DO 30 J=1,I-1                                                   
          D(J)  = THN(J)                                                
          BP(J) = CP(J)                                                 
          BS(J) = CS(J)                                                 
          RH(J) = RHO(J)                                                
   30   CONTINUE                                                        
        D(I+1)  = S - DS                                                
        BP(I+1) = CP(I)                                                 
        BS(I+1) = CS(I)                                                 
        RH(I+1) = RHO(I)                                                
        D(I  )  = THN(I) - D(I+1)                                       
        BP(I  ) = CP(I)                                                 
        BS(I  ) = CS(I)                                                 
        RH(I  ) = RHO(I)                                                
      ENDIF                                                             
      DO 40 J=I+1,NOL                                                   
        D(J+1)  = THN(J)                                                
        BP(J+1) = CP(J)                                                 
        BS(J+1) = CS(J)                                                 
        RH(J+1) = RHO(J)                                                
   40 CONTINUE                                                          
      RETURN                                                            
C                                                                       
      END                                                               
c                                                                       
      subroutine npsvsh(n,ns,a,b,rho,d,u,freq,uw)                       
      implicit complex*16 (a-h,o-z)                                      
      real*8   rho(n),d(n),rec,rep,res                                 
      dimension a(n),b(n),uw(10)                                        
      ns1 = ns + 1                                                      
      pi = 3.14159265e0                                                 
      ai = (0.,1.)                                                      
      omeg = 2.*pi*freq                                                 
      c = 1./u                                                          
      rec = real(c)                                                     
      rk = omeg*u                                                       
      com = c*omeg                                                      
      u2 = u*u                                                          
      c2 = c*c                                                          
      rk2 = rk*rk                                                       
      om2 = omeg*omeg                                                   
c   delta matrix for halfspace (pv)                                     
c   g-matrix     for halfspace (sh)                                     
      s = b(n)                                                          
      p = a(n)                                                          
      rep = real(p)                                                     
      res = real(s)                                                     
      rro = rho(n)                                                      
      s2 = s*s                                                          
      p2 = p*p                                                          
      argp = 1.-c2/p2                                                   
      args = 1.-c2/s2                                                   
        if(rec.gt.rep) cn = rk*sqrt(-argp)                              
        if(rec.le.rep) cn = -rk*sqrt(argp)*ai                           
        if(rec.gt.res) cns = rk*sqrt(-args)                             
        if(rec.le.res) cns = -rk*sqrt(args)*ai                          
      rl = 2.*rk2-om2/s2                                                
      rpp = cn*cns                                                      
      t1 = -s2*s2*rro/(om2+om2)*(4.*rk2*rpp+rl*rl)                      
      t2 = cmplx(0.,0.5)*cn                                             
      t3 = -s2*u/(2.*omeg)*ai*(rl+rpp+rpp)                              
      t4 = cmplx(0.,-0.5)*cns                                           
      t5 = -1./(2.*rro*om2)*(rpp+rk2)                                   
      v1 = (-0.5,0.)                                                    
      v2 = (0.,0.5)/(s2*rro*cns)                                        
        if(ns1.ne.n) go to 900                                          
      th1 = t1                                                          
      th2 = t2                                                          
      th3 = t3                                                          
      th5 = t4                                                          
      th6 = t5                                                          
      vh1 = v1                                                          
      vh2 = v2                                                          
  900 t3 = t3*2.                                                        
c   delta matrix for layers (pv)                                        
c   g-matrix     for layers (sh)                                        
      do 1000 j=2,n                                                     
      i = n-j+1                                                         
      s = b(i)                                                          
      s2 = s*s                                                          
      p = a(i)                                                          
      p2 = p*p                                                          
      rep = real(p)                                                     
      res = real(s)                                                     
      thk = rk*d(i)                                                     
      argp = 1.-c2/p2                                                   
        if(rec.le.rep) go to 190                                        
      ra = sqrt(-argp)                                                  
      p = thk*ra                                                        
      pn = 1.                                                           
      sp = sin(p)                                                       
      cp = cos(p)                                                       
      x = ra*sp                                                         
  180 args = 1.-c2/s2                                                   
        if(rec.le.res) go to 200                                        
      rb = sqrt(-args)                                                  
      q = thk*rb                                                        
      qn = 1.                                                           
      sq = sin(q)                                                       
      cq = cos(q)                                                       
      z = sq*rb                                                         
      go to 210                                                         
  190 ra = -sqrt(argp)                                                  
      p = thk*ra                                                        
      ep = 0.5*exp(p)                                                   
      em = 0.25/ep                                                      
      pn = ep+em                                                        
      sp =(ep-em)/pn                                                    
      cp = 1.                                                           
      x = -sp*ra                                                        
      go to 180                                                         
  200 rb = -sqrt(args)                                                  
      q = thk*rb                                                        
      ep = 0.5*exp(q)                                                   
      em = 0.25/ep                                                      
      qn = ep+em                                                        
      sq =(ep-em)/qn                                                    
      cq = 1.                                                           
      z = -sq*rb                                                        
  210   if(abs(real(p)).lt.1.0e-6) go to 211                            
      w = sp/ra                                                         
      go to 213                                                         
  211 w = thk                                                           
  213   if(abs(real(q)).lt.1.0e-6) go to 212                            
      y = sq/rb                                                         
      go to 214                                                         
  212 y = thk                                                           
  214 continue                                                          
c   delta matrix                                                        
      g1 =-2.*s2*u2                                                     
      g2 = g1+1.                                                        
      e0 = 1./(pn*qn)                                                   
      e1 = cp*cq                                                        
      e2 = e0-e1                                                        
      e3 = w*y                                                          
      e4 = x*z                                                          
      e5 = w*cq                                                         
      e6 = y*cp                                                         
      r1 = com*rho(i)                                                   
      r2 = 1./r1                                                        
      r3 = r1*g1                                                        
      r4 = r1*g2                                                        
      f1 = e2+e3                                                        
      f2 = f1*r2                                                        
      g16 = -r2*(f2+(e2+e4)*r2)                                         
      g13 = -r3*g16+f2                                                  
      f3 = g1*f1+e3                                                     
      f4 = r3*g13+f3                                                    
      g31 = r3*f4+f3*r4                                                 
      g11 = e1-f4                                                       
      g33 = f4+0.5*e0                                                   
      g61 = -r3*g31-r4*(e3*r4+f3*r3)                                    
      g15 = -r2*(e5+z*cp)                                               
      g23 = -r3*g15+e5                                                  
      g21 = -r3*g23-r4*e5                                               
      g12 = r2*(e6+x*cq)                                                
      g32 = -r3*g12-e6                                                  
      g51 = -r3*g32+r4*e6                                               
      g22 = e1                                                          
      g25 = z*w                                                         
      g52 = x*y                                                         
      g13 = g13*ai                                                      
      g31 = g31*ai                                                      
      g23 = g23*ai                                                      
      g32 = g32*ai                                                      
      tr1 = t1*g11+t2*g21+t3*g31+t4*g51+t5*g61                          
      tr2 = t1*g12+t2*g22+t3*g32+t4*g52+t5*g51                          
      tr3 = t1*g13+t2*g23+t3*g33+t4*g32+t5*g31                          
      tr4 = t1*g15+t2*g25+t3*g23+t4*g22+t5*g21                          
      t5  = t1*g16+t2*g15+t3*g13+t4*g12+t5*g11                          
      t1 = tr1                                                          
      t2 = tr2                                                          
      t3 = 2.*tr3                                                       
      t4 = tr4                                                          
      rm = s2*rho(i)                                                    
c   g-matrix (sh)                                                       
      vr1 = v1*cq + v2*(-z*rm*rk)                                       
      v2  = v1*y/(rm*rk) + v2*cq                                        
      v1  = vr1                                                         
      if(i-ns1) 1100,1500,1000                                          
c   g-matrix (pv)                                                       
 1100 cp  = cp/qn                                                       
      w   = w /qn                                                       
      x   = x /qn                                                       
      cq  = cq/pn                                                       
      y   = y /pn                                                       
      z   = z /pn                                                       
      a11 = -g1*cp + g2*cq                                              
      a21 =(-g1*x - g2*y)*ai                                            
      a31 = -r1*g1*g2*(cp-cq)*ai                                        
      a41 = -r3*g1*x - r4*g2*y                                          
      a12 =( g2*w + g1*z)*ai                                            
      a13 =  r2*(cq-cp)*ai                                              
      a14 =  r2*(w+z)                                                   
      a22 =  g2*cp - g1*cq                                              
      a23 =  r2*(x+y)                                                   
      a32 = -r4*g2*w - r3*g1*z                                          
      vh1 = vh1/qn                                                      
      vh2 = vh2/qn                                                      
        if (i.eq.ns) go to 1200                                         
      tr11 = s11*a11+s12*a21+s13*a31+s14*a41                            
      tr21 = s21*a11+s22*a21+s23*a31+s24*a41                            
      tr31 = s31*a11+s32*a21+s33*a31+s34*a41                            
      tr41 = s41*a11+s42*a21+s43*a31+s44*a41                            
      tr12 = s11*a12+s12*a22+s13*a32+s14*a31                            
      tr22 = s21*a12+s22*a22+s23*a32+s24*a31                            
      tr32 = s31*a12+s32*a22+s33*a32+s34*a31                            
      tr42 = s41*a12+s42*a22+s43*a32+s44*a31                            
      tr13 = s11*a13+s12*a23+s13*a22+s14*a21                            
      tr23 = s21*a13+s22*a23+s23*a22+s24*a21                            
      tr33 = s31*a13+s32*a23+s33*a22+s34*a21                            
      tr43 = s41*a13+s42*a23+s43*a22+s44*a21                            
      s14  = s11*a14+s12*a13+s13*a12+s14*a11                            
      s24  = s21*a14+s22*a13+s23*a12+s24*a11                            
      s34  = s31*a14+s32*a13+s33*a12+s34*a11                            
      s44  = s41*a14+s42*a13+s43*a12+s44*a11                            
      s11 = tr11                                                        
      s21 = tr21                                                        
      s31 = tr31                                                        
      s41 = tr41                                                        
      s12 = tr12                                                        
      s22 = tr22                                                        
      s32 = tr32                                                        
      s42 = tr42                                                        
      s13 = tr13                                                        
      s23 = tr23                                                        
      s33 = tr33                                                        
      s43 = tr43                                                        
      go to 1000                                                        
1200  s11 = a11                                                         
      s21 = a21                                                         
      s31 = a31                                                         
      s41 = a41                                                         
      s12 = a12                                                         
      s22 = a22                                                         
      s32 = a32                                                         
      s42 = a31                                                         
      s13 = a13                                                         
      s23 = a23                                                         
      s33 = a22                                                         
      s43 = a21                                                         
      s14 = a14                                                         
      s24 = a13                                                         
      s34 = a12                                                         
      s44 = a11                                                         
      go to 1000                                                        
 1500   th1 = t1                                                        
        th2 = t2                                                        
        th3 = t3/2.                                                     
        th5 = t4                                                        
        th6 = t5                                                        
        vh1 = v1                                                        
        vh2 = v2                                                        
 1000 continue                                                          
      uw(1) = (-s22*th1-s32*th2-s42*th3)/t1                             
      uw(2) = ( s12*th1-s32*th3-s42*th5)/t1                             
      uw(3) = ( s12*th2+s22*th3-s42*th6)/t1                             
      uw(4) = ( s12*th3+s22*th5+s32*th6)/t1                             
      uw(5) = ( s21*th1+s31*th2+s41*th3)/t1                             
      uw(6) = (-s11*th1+s31*th3+s41*th5)/t1                             
      uw(7) = (-s11*th2-s21*th3+s41*th6)/t1                             
      uw(8) = (-s11*th3-s21*th5-s31*th6)/t1                             
      uw(9) = vh1/v1                                                    
      uw(10)= vh2/v1                                                    
      return                                                            
      end                                                               
c                                                                       
      subroutine nlogn(n,x,sign)                                        
      implicit real*8 (a-h, o-z)
      complex*16 x,wk,hold,q                                            
      dimension m(15),x(2)                                              
      lx=2**n                                                           
      do 1 i=1,n                                                        
1     m(i)=2**(n-i)                                                     
      do 4 l=1,n                                                        
      nblock=2**(l-1)                                                   
      lblock=lx/nblock                                                  
      lbhalf=lblock/2                                                   
      k=0                                                               
      do 4 iblock=1,nblock                                              
      fk=k                                                              
      flx=lx                                                            
      v=sign*6.2831853e0*fk/flx                                         
      wk=cmplx(cos(v),sin(v))                                           
      istart=lblock*(iblock-1)                                          
      do 2 i=1,lbhalf                                                   
      j=istart+i                                                        
      jh=j+lbhalf                                                       
      q=x(jh)*wk                                                        
      x(jh)=x(j)-q                                                      
      x(j)=x(j)+q                                                       
2     continue                                                          
      do 3 i=2,n                                                        
      ii=i                                                              
      if(k.lt.m(i)) go to 4                                             
3     k=k-m(i)                                                          
4     k=k+m(ii)                                                         
      k=0                                                               
      do 7 j=1,lx                                                       
      if(k.lt.j) go to 5                                                
      hold=x(j)                                                         
      x(j)=x(k+1)                                                       
      x(k+1)=hold                                                       
5     do 6 i=1,n                                                        
      ii=i                                                              
      if(k.lt.m(i)) go to 7                                             
6     k=k-m(i)                                                          
7     k=k+m(ii)                                                         
      if(sign.lt.0.0) return                                            
      do 8 i=1,lx                                                       
8     x(i)=x(i)/flx                                                     
      return                                                            
      end                                                               
c
      function besj0 (x)
c april 1977 version.  w. fullerton, c3, los alamos scientific lab.
      implicit real*8 (a-h, o-z)
      dimension bj0cs(13), bm0cs(21), bth0cs(24)
c      external cos, csevl, inits, r1mach, sqrt
c
c series for bj0        on the interval  0.          to  1.60000d+01
c                                        with weighted error   7.47e-18
c                                         log weighted error  17.13
c                               significant figures required  16.98
c                                    decimal places required  17.68
c
      data bj0 cs( 1) /    .1002541619 68939137e0 /
      data bj0 cs( 2) /   -.6652230077 64405132e0 /
      data bj0 cs( 3) /    .2489837034 98281314e0 /
      data bj0 cs( 4) /   -.0332527231 700357697e0 /
      data bj0 cs( 5) /    .0023114179 304694015e0 /
      data bj0 cs( 6) /   -.0000991127 741995080e0 /
      data bj0 cs( 7) /    .0000028916 708643998e0 /
      data bj0 cs( 8) /   -.0000000612 108586630e0 /
      data bj0 cs( 9) /    .0000000009 838650793e0 /
      data bj0 cs(10) /   -.0000000000 124235515e0 /
      data bj0 cs(11) /    .0000000000 001265433e0 /
      data bj0 cs(12) /   -.0000000000 000010619e0 /
      data bj0 cs(13) /    .0000000000 000000074e0 /
c
c series for bm0        on the interval  0.          to  6.25000d-02
c                                        with weighted error   4.98e-17
c                                         log weighted error  16.30
c                               significant figures required  14.97
c                                    decimal places required  16.96
c
      data bm0 cs( 1) /    .0928496163 7381644e0 /
      data bm0 cs( 2) /   -.0014298770 7403484e0 /
      data bm0 cs( 3) /    .0000283057 9271257e0 /
      data bm0 cs( 4) /   -.0000014330 0611424e0 /
      data bm0 cs( 5) /    .0000001202 8628046e0 /
      data bm0 cs( 6) /   -.0000000139 7113013e0 /
      data bm0 cs( 7) /    .0000000020 4076188e0 /
      data bm0 cs( 8) /   -.0000000003 5399669e0 /
      data bm0 cs( 9) /    .0000000000 7024759e0 /
      data bm0 cs(10) /   -.0000000000 1554107e0 /
      data bm0 cs(11) /    .0000000000 0376226e0 /
      data bm0 cs(12) /   -.0000000000 0098282e0 /
      data bm0 cs(13) /    .0000000000 0027408e0 /
      data bm0 cs(14) /   -.0000000000 0008091e0 /
      data bm0 cs(15) /    .0000000000 0002511e0 /
      data bm0 cs(16) /   -.0000000000 0000814e0 /
      data bm0 cs(17) /    .0000000000 0000275e0 /
      data bm0 cs(18) /   -.0000000000 0000096e0 /
      data bm0 cs(19) /    .0000000000 0000034e0 /
      data bm0 cs(20) /   -.0000000000 0000012e0 /
      data bm0 cs(21) /    .0000000000 0000004e0 /
c
c series for bth0       on the interval  0.          to  6.25000d-02
c                                        with weighted error   3.67e-17
c                                         log weighted error  16.44
c                               significant figures required  15.53
c                                    decimal places required  17.13
c
      data bth0cs( 1) /   -.2463916377 4300119e0 /
      data bth0cs( 2) /    .0017370983 07508963e0 /
      data bth0cs( 3) /   -.0000621836 33402968e0 /
      data bth0cs( 4) /    .0000043680 50165742e0 /
      data bth0cs( 5) /   -.0000004560 93019869e0 /
      data bth0cs( 6) /    .0000000621 97400101e0 /
      data bth0cs( 7) /   -.0000000103 00442889e0 /
      data bth0cs( 8) /    .0000000019 79526776e0 /
      data bth0cs( 9) /   -.0000000004 28198396e0 /
      data bth0cs(10) /    .0000000001 02035840e0 /
      data bth0cs(11) /   -.0000000000 26363898e0 /
      data bth0cs(12) /    .0000000000 07297935e0 /
      data bth0cs(13) /   -.0000000000 02144188e0 /
      data bth0cs(14) /    .0000000000 00663693e0 /
      data bth0cs(15) /   -.0000000000 00215126e0 /
      data bth0cs(16) /    .0000000000 00072659e0 /
      data bth0cs(17) /   -.0000000000 00025465e0 /
      data bth0cs(18) /    .0000000000 00009229e0 /
      data bth0cs(19) /   -.0000000000 00003448e0 /
      data bth0cs(20) /    .0000000000 00001325e0 /
      data bth0cs(21) /   -.0000000000 00000522e0 /
      data bth0cs(22) /    .0000000000 00000210e0 /
      data bth0cs(23) /   -.0000000000 00000087e0 /
      data bth0cs(24) /    .0000000000 00000036e0 /
c
      data pi4 / 0.7853981633 9744831e0 /
      data ntj0, ntm0, ntth0, xsml, xmax / 3*0, 2*0./
c
      if (ntj0.ne.0) go to 10
c      ntj0 = inits (bj0cs, 13, 0.1*r1mach(3))
c      ntm0 = inits (bm0cs, 21, 0.1*r1mach(3))
c      ntth0 = inits (bth0cs, 24, 0.1*r1mach(3))
      ntj0 = inits (bj0cs, 13, 0.1*d1mach(3))
      ntm0 = inits (bm0cs, 21, 0.1*d1mach(3))
      ntth0 = inits (bth0cs, 24, 0.1*d1mach(3))
c
c      xsml = sqrt (4.0*r1mach(3))
c      xmax = 1.0/r1mach(4)
      xsml = sqrt (4.0*d1mach(3))
      xmax = 1.0/d1mach(4)
c
 10   y = abs(x)
      if (y.gt.4.0) go to 20
c
      besj0 = 1.0
      if (y.gt.xsml) besj0 = csevl (.125*y*y-1., bj0cs, ntj0)
      return
c
 20   if (y.gt.xmax) call seteru (
     1  'besj0   no precision because abs(x) is big', 42, 1, 2)
c
      z = 32.0/y**2 - 1.0
      ampl = (0.75 + csevl (z, bm0cs, ntm0)) / sqrt(y)
      theta = y - pi4 + csevl (z, bth0cs, ntth0) / y
      besj0 = ampl * cos (theta)
c
      return
      end
c
      function besj1 (x)
c sept 1983 edition.  w. fullerton, c3, los alamos scientific lab.
      implicit real*8 (a-h, o-z)
      dimension bj1cs(12), bm1cs(21), bth1cs(24)
c      external cos, csevl, inits, r1mach, sqrt
c
c series for bj1        on the interval  0.          to  1.60000d+01
c                                        with weighted error   4.48e-17
c                                         log weighted error  16.35
c                               significant figures required  15.77
c                                    decimal places required  16.89
c
      data bj1 cs( 1) /   -.1172614151 3332787e0 /
      data bj1 cs( 2) /   -.2536152183 0790640e0 /
      data bj1 cs( 3) /    .0501270809 84469569e0 /
      data bj1 cs( 4) /   -.0046315148 09625081e0 /
      data bj1 cs( 5) /    .0002479962 29415914e0 /
      data bj1 cs( 6) /   -.0000086789 48686278e0 /
      data bj1 cs( 7) /    .0000002142 93917143e0 /
      data bj1 cs( 8) /   -.0000000039 36093079e0 /
      data bj1 cs( 9) /    .0000000000 55911823e0 /
      data bj1 cs(10) /   -.0000000000 00632761e0 /
      data bj1 cs(11) /    .0000000000 00005840e0 /
      data bj1 cs(12) /   -.0000000000 00000044e0 /
c
c series for bm1        on the interval  0.          to  6.25000d-02
c                                        with weighted error   5.61e-17
c                                         log weighted error  16.25
c                               significant figures required  14.97
c                                    decimal places required  16.91
c
      data bm1 cs( 1) /    .1047362510 931285e0 /
      data bm1 cs( 2) /    .0044244389 3702345e0 /
      data bm1 cs( 3) /   -.0000566163 9504035e0 /
      data bm1 cs( 4) /    .0000023134 9417339e0 /
      data bm1 cs( 5) /   -.0000001737 7182007e0 /
      data bm1 cs( 6) /    .0000000189 3209930e0 /
      data bm1 cs( 7) /   -.0000000026 5416023e0 /
      data bm1 cs( 8) /    .0000000004 4740209e0 /
      data bm1 cs( 9) /   -.0000000000 8691795e0 /
      data bm1 cs(10) /    .0000000000 1891492e0 /
      data bm1 cs(11) /   -.0000000000 0451884e0 /
      data bm1 cs(12) /    .0000000000 0116765e0 /
      data bm1 cs(13) /   -.0000000000 0032265e0 /
      data bm1 cs(14) /    .0000000000 0009450e0 /
      data bm1 cs(15) /   -.0000000000 0002913e0 /
      data bm1 cs(16) /    .0000000000 0000939e0 /
      data bm1 cs(17) /   -.0000000000 0000315e0 /
      data bm1 cs(18) /    .0000000000 0000109e0 /
      data bm1 cs(19) /   -.0000000000 0000039e0 /
      data bm1 cs(20) /    .0000000000 0000014e0 /
      data bm1 cs(21) /   -.0000000000 0000005e0 /
c
c series for bth1       on the interval  0.          to  6.25000d-02
c                                        with weighted error   4.10e-17
c                                         log weighted error  16.39
c                               significant figures required  15.96
c                                    decimal places required  17.08
c
      data bth1cs( 1) /    .7406014102 6313850e0 /
      data bth1cs( 2) /   -.0045717556 59637690e0 /
      data bth1cs( 3) /    .0001198185 10964326e0 /
      data bth1cs( 4) /   -.0000069645 61891648e0 /
      data bth1cs( 5) /    .0000006554 95621447e0 /
      data bth1cs( 6) /   -.0000000840 66228945e0 /
      data bth1cs( 7) /    .0000000133 76886564e0 /
      data bth1cs( 8) /   -.0000000024 99565654e0 /
      data bth1cs( 9) /    .0000000005 29495100e0 /
      data bth1cs(10) /   -.0000000001 24135944e0 /
      data bth1cs(11) /    .0000000000 31656485e0 /
      data bth1cs(12) /   -.0000000000 08668640e0 /
      data bth1cs(13) /    .0000000000 02523758e0 /
      data bth1cs(14) /   -.0000000000 00775085e0 /
      data bth1cs(15) /    .0000000000 00249527e0 /
      data bth1cs(16) /   -.0000000000 00083773e0 /
      data bth1cs(17) /    .0000000000 00029205e0 /
      data bth1cs(18) /   -.0000000000 00010534e0 /
      data bth1cs(19) /    .0000000000 00003919e0 /
      data bth1cs(20) /   -.0000000000 00001500e0 /
      data bth1cs(21) /    .0000000000 00000589e0 /
      data bth1cs(22) /   -.0000000000 00000237e0 /
      data bth1cs(23) /    .0000000000 00000097e0 /
      data bth1cs(24) /   -.0000000000 00000040e0 /
c
c
      data pi4 / 0.7853981633 9744831e0 /
      data ntj1, ntm1, ntth1, xsml, xmin, xmax / 3*0, 3*0./
c
      if (ntj1.ne.0) go to 10
c      ntj1 = inits (bj1cs, 12, 0.1*r1mach(3))
c      ntm1 = inits (bm1cs, 21, 0.1*r1mach(3))
c      ntth1 = inits (bth1cs, 24, 0.1*r1mach(3))
      ntj1 = inits (bj1cs, 12, 0.1*d1mach(3))
      ntm1 = inits (bm1cs, 21, 0.1*d1mach(3))
      ntth1 = inits (bth1cs, 24, 0.1*d1mach(3))
c
c      xsml = sqrt (8.0*r1mach(3))
c      xmin = 2.0*r1mach(1)
c      xmax = 1.0/r1mach(4)
      xsml = sqrt (8.0*d1mach(3))
      xmin = 2.0*d1mach(1)
      xmax = 1.0/d1mach(4)
c
 10   y = abs(x)
      if (y.gt.4.0) go to 20
c
      besj1 = 0.0
      if (y.eq.0.0) return
      if (y.le.xmin) call seteru (
     1  'besj1   abs(x) so small j1 underflows', 37, 1, 0)
      if (y.gt.xmin) besj1 = 0.5*x
      if (y.gt.xsml) besj1 = x * (.25 + csevl(.125*y*y-1., bj1cs, ntj1))
      return
c
 20   if (y.gt.xmax) call seteru (
     1  'besj1   no precision because abs(x) is big', 42, 2, 2)
      z = 32.0/y**2 - 1.0
      ampl = (0.75 + csevl (z, bm1cs, ntm1)) / sqrt(y)
      theta = y - 3.0*pi4 + csevl (z, bth1cs, ntth1) / y
      besj1 = sign (ampl, x) * cos (theta)
c
      return
      end
c
      function csevl (x, cs, n)
c april 1977 version.  w. fullerton, c3, los alamos scientific lab.
c
c evaluate the n-term chebyshev series cs at x.  adapted from
c r. broucke, algorithm 446, c.a.c.m., 16, 254 (1973).  also see fox
c and parker, chebyshev polys in numerical analysis, oxford press, p.56.
c
c             input arguments --
c x      value at which the series is to be evaluated.
c cs     array of n terms of a chebyshev series.  in eval-
c        uating cs, only half the first coef is summed.
c n      number of terms in array cs.
c
      implicit real*8 (a-h, o-z)
      dimension cs(1)
c
      if (n.lt.1) call seteru ('csevl   number of terms le 0', 28, 2,2)
      if (n.gt.1000) call seteru ('csevl   number of terms gt 1000',
     1  31, 3, 2)
      if (x.lt.(-1.1) .or. x.gt.1.1) call seteru (
     1  'csevl   x outside (-1,+1)', 25, 1, 1)
c
      b1 = 0.
      b0 = 0.
      twox = 2.*x
      do 10 i=1,n
        b2 = b1
        b1 = b0
        ni = n + 1 - i
        b0 = twox*b1 - b2 + cs(ni)
 10   continue
c
      csevl = 0.5 * (b0-b2)
c
      return
      end
c
      subroutine seteru (messg, nmessg, nerr, iopt)
      implicit real*8 (a-h, o-z)
      common /cseter/ iunflo
c      integer messg(1)
      character*1 messg(nmessg)
      data iunflo / 0 /
c
c      if (iopt.ne.0) call seterr (messg, nmessg, nerr, iopt)
      if (iopt.ne.0) write(*,'(50a1)') (messg(i),i=1,nmessg)
      if (iopt.ne.0) return
c
      if (iunflo.le.0) return
c      call seterr (messg, nmessg, nerr, 1)
      write(*,'(50a1)') (messg(i),i=1,nmessg)
c
      return
      end
c
      function inits (os, nos, eta)
c april 1977 version.  w. fullerton, c3, los alamos scientific lab.
c
c initialize the orthogonal series so that inits is the number of terms
c needed to insure the error is no larger than eta.  ordinarily, eta
c will be chosen to be one-tenth machine precision.
c
c             input arguments --
c os     array of nos coefficients in an orthogonal series.
c nos    number of coefficients in os.
c eta    requested accuracy of series.
c
      implicit real*8 (a-h, o-z)
      dimension os(nos)
c
      if (nos.lt.1) call seteru (
     1  'inits   number of coefficients lt 1', 35, 2, 2)
c
      err = 0.
      do 10 ii=1,nos
        i = nos + 1 - ii
        err = err + abs(os(i))
        if (err.gt.eta) go to 20
 10   continue
c
 20   if (i.eq.nos) call seteru ('inits   eta may be too small', 28,
     1  1, 2)
      inits = i
c
      return
      end
