c*********************************************************************  
c*   Extended Reflectivity Method (point source)                     *  
c*                                                                   *  
c*<Modification History>                                             *  
c*  08/30/1984  Initial version                                      *  
c*  01/11/1985  ICMP option                                          *  
c*  07/30/1992  various observation points                           *  
c*  12/20/1994  distance loop                                        *  
c*  03/22/1995  FREF & list format                                   *  
c*  06/25/1999  explicit double precision                            *  
c*  12/07/2000  Remove unexpected limitation of NLOGN.               *  
c*  05/30/2001  real() -> dble()                                     *  
c*  06/25/2001  FREF=5->1Hz for ISRC=0,1. Remove a debugging WRITE.  *  
c*  10/25/2025  Bessel functions from Netlib and machine.f90         *  
c*                                                                   *  
c* <Input Data>                                                      *  
c*  All parameters are required without exception.   But meaningless *  
C*  parms.(e.g. dip angle of explosion) can be specified with blanks.*  
c*  ns      ; interface no. of source                                *  
c*  iopt    ; 1-integrated, 2-as is, 3-differentiated                *  
c*  ityp    ; 0-explosion, 1-dislocation                             *  
c*  isrc    ;-1-Gavor, 0-Herrmann, 1-ramp function+instrument        *  
c*  icmp    ; 0-all, 1-NS(radial), 2-EW(transverse), 3-vertical      *  
c*  ast     ; fault strike from north                                *  
c*  adp     ; dip angle                                              *  
c*  asd     ; slip direction                                         *  
c*  tc(1-3) ; natural period of seismograph (R, T, Z)                *  
c*  hc(1-3) ; damping factor of seismograph (R, T, Z)                *  
c*  vc(1-3) ; static magnification of seismograph (R, T, Z)          *  
c*  smom    ; seismic moment                                         *  
c*  fu,fwil ; left corners of cosine tapered window                  *  
c*  fwir,fo ; right corners of cosine tapered window                 *  
c* alim,blim; upper & lower limits of phase velocity window          *  
c*  index   ; exp. factor of no. of time points (2**index)           *  
c*  wi      ; imaginary part of frequency                            *  
c*  vred    ; velocity of reduction                                  *  
c*  ti,tl   ; lower & upper limits of time window                    *  
c*  dt      ; time increment                                         *  
c*  ts      ; parameter of source time function (rise time)          *  
c*  gam,fnu ; parameters for wavelet                                 *  
c*  fref    ; reference frequency of causal Q model                  *  
c*  thn(i)  ; thickness of layer (max 20, ended by 0.)               *  
c*  vp,vs(i); P- and S-velocities                                    *  
c*  rho(i)  ; density                                                *  
c*  qp,qs(i); Q-factors for P- and S-waves                           *  
c*  r,az(i) ; observer distances and azimuths (max 20, ended by -1.) *  
C*********************************************************************
      parameter (ml = 20, mr = 20)
      implicit real*8 (a-h, o-z)
      dimension  thn(ml),vp(ml),vs(ml),rho(ml),qp(ml),qs(ml)            
     *          ,r(mr),az(mr),t(mr),amw(4096),tc(3),hc(3),vc(3)
      complex*16 w1,w2,w3,ai,pw(4096,mr*3),dum(8192),s(4096,3)            
     *          ,cp(ml),cs(ml),uw(10)                                   
     *          ,dl02,dl04,dl11,dl24,ds11,ds22                          
     *          ,frq,omeg,omeg2,u,va,vb,br,ak2,bk2                      
      character*12 charac,type                                          
      data ai/(0.,1.)/,pi2/6.283185/,pi/3.141593/                       
c                                                                       
c         (allow overflows on a mainframe)
c      call errset(207, 256, 0, 0, 0)                                  
c         (set the input file on workstations)
c      open(5, file="rzdemo2")                                  
c                                                                       
c   input                                                               
c                                                                       
  500 format(5i5)                                                       
  510 format(7g10.3)                                                    
      read(5,500) ns,iopt,ityp,isrc,icmp                                
      read(5,510) ast,adp,asd                                       
      do 9 i=1,3                                                        
      read(5,510) tc(i),hc(i),vc(i)                                     
    9 continue                                                          
      read(5,510) smom                                                  
      read(5,510) fu,fwil,fwir,fo                                       
      read(5,510) alim,blim,dk                                          
      read(5,500) index                                                 
      read(5,510) wi                                                    
      read(5,510) vred,ti,tl                                            
      read(5,510) dt,ts,gam,fnu                                         
c******* layer parameters *******                                       
      do 10 i=1,20                                                      
        nol=i                                                           
        read(5,510) thn(i),vp(i),vs(i),rho(i),qp(i),qs(i)               
          if(vs(i) .eq.0.)     vs(i) = vp(i)/1.732051                   
          if(rho(i).eq.0.)    rho(i) = vp(i)*0.3788 + 0.252             
          if(qp(i).gt.0. .and. qs(i).eq.0.) qs(i) = qp(i)*4./9.         
          if(thn(i).eq.0.)    go to 1000                                
   10 continue                                                          
c******* epicentral distances *******                                   
 1000 do 15 j=1,mr
          read(5,510) r(j), az(j)
          if(r(j) .lt. 0.) then
              nent = j - 1
              go to 1900
          endif
 15   continue
      nent = j
 1900 continue
      do 59 kr=1,nent                                                   
          t(kr) = ti + r(kr)/vred
 59   continue
      nc = nent*3                                                       
c******* time constants *******                                         
      npts = 2**index                                                   
      inpt = npts/2                                                     
      fnpt = npts                                                       
      dauer = dt*(fnpt-1.)                                              
      df    = 1./(dauer+dt)                                             
      if(wi .eq. 0.) wi = pi2/2./dauer                                  
c                                                                       
c   source                                                              
c                                                                       
      fref = 1.                                                         
      if(isrc) 1410,1420,1430                                           
 1410 write(6,634) ts,gam,fnu                                           
  634 format(1h ,//,' Gavor wavelet (',3f10.5,')')                      
      fref = ts                                                         
      shift = 0.241506*gam/ts                                           
      do 28 j=1,3                                                       
        do 29 i=1,npts                                                  
          tt = dt*(i-1) - shift                                         
          if(tt .gt. shift+2.) then                                     
            s(i,j) = 0.                                                 
          else                                                          
            s(i,j) = exp(-(pi2*ts*tt/gam)**2)*cos(pi2*ts*tt+fnu)        
     *             * smom/1.e20                                         
          endif                                                         
   29   continue                                                        
        call nlogn(index, s(1,j), -1.d0)                                  
   28 continue                                                          
      go to 1500                                                        
 1420 write(6,635) ts                                                   
  635 format(1h ,//,' Herrmann-type source (',f10.5,')')                
      do 31 j=1,3                                                       
        do 32 i=1,npts                                                  
          tt = dt*(i-1)/ts                                              
            if(tt.le.1.)                s(i,j) = tt*tt/2.               
            if(tt.gt.1. .and. tt.le.3.) s(i,j) = -(tt-2.)*(tt-2.)/2.+1. 
            if(tt.gt.3. .and. tt.le.4.) s(i,j) = (tt-4.)*(tt-4.)/2.     
            if(tt.gt.4.)                s(i,j) = 0.                     
          s(i,j) = smom/1.e20 * s(i,j)/(2.*ts)*exp(-tt*ts*wi)           
   32   continue                                                        
        call nlogn(index, s(1,j), -1.d0)                                  
   31 continue                                                          
      go to 1500                                                        
 1430 write(6,636) ts                                                   
  636 format(1h ,//,' ramp function source (',f10.5,')')                
      write(6,637) tc,hc,vc                                             
  637 format(' natural period   ',3f10.5/
     *      ,' damping coeff.   ',3f10.5/                              
     *      ,' magnification    ',3f10.5/)                              
      do 39 j=1,3                                                       
        if (tc(j) .ne. 0.) cn = pi2/tc(j)                               
        do 35 i=1,inpt                                                  
          omeg  = cmplx(df*pi2*(i-1),-wi)                               
          omeg2 = omeg**2                                               
          s(i,j) = smom/1.e20/ts * (exp(-ai*omeg*ts)-1.)/omeg2 / dt     
            if (tc(j) .eq. 0.) go to 351                                
          s(i,j) = s(i,j)*vc(j)*omeg2/(omeg2-cn**2-2.*hc(j)*cn*omeg*ai) 
  351       if(i .eq. 1) s(i,j) = s(i,j) + pi                           
   35   continue                                                        
   39 continue                                                          
c                                                                       
c   spectrum window                                                     
c                                                                       
 1500 iu  = fu*dauer+1.                                                 
      io  = fo*dauer+1.                                                 
      nfz = io-iu+1                                                     
      ileft  = fwil*dauer+1.                                            
      iright = fwir*dauer+1.                                            
      nleft  = ileft-iu                                                 
      nright = io-iright                                                
        if(nleft .gt.0) dleft  = pi2/2./nleft                           
        if(nright.gt.0) dright = pi2/2./nright                          
      do 41 j=1,3                                                       
        do 40 i=1,inpt                                                  
          fif = i-iright                                                
          faf = i-iu                                                    
            if(i.le.iu.or.i.ge.io) s(i,j) = 0.                          
            if(i.gt.iu.and.i.lt.ileft)                                  
     *      s(i,j) = s(i,j)*(0.5-cos(dleft*faf)/2.)                     
            if(i.gt.iright.and.i.lt.io)                                 
     *      s(i,j) = s(i,j)*(cos(dright*fif)/2.+0.5)                    
   40   continue                                                        
   41 continue                                                          
c                                                                       
c   parameter list                                                      
c                                                                       
      write(6,600)                                                      
  600 format(1h ////,5x,'structure'//,10x,'thickness',5x,               
     1       'Vp',9x,'Vs',9x,'rho',8x,'Qp',9x,'Qs')                     
      write(6,605) (thn(i),vp(i),vs(i),rho(i),qp(i),qs(i),i=1,nol)      
  605 format(1h ,5x,f12.2,5f11.3)                                       
      write(6,610)
  610 format(1h //,5x,'observer distances & azimuths =')
      write(6,626) (r(i),az(i),i=1,nent)                                      
  626 format(5x,2g10.3)
      write(6,611)  ns,wi,fu,fo,alim,blim,nfz,df,dk,ti,tl,vred          
  611 format(5x,'source layer (no.) =',i3/                              
     *     , 5x,'time attenuation   =',f7.2/                            
     *     ,10x,'limits of integration'/                                
     *     ,15x,'frequency   ',f7.2,' Hz--',f7.2,' Hz'/                 
     *     ,15x,'phase vel.   ',e8.3,' --',f7.3,' km/s'/                
     *     ,10x,'data size for integration'/                            
     *     ,15x,'frequency   ',2x,i5,' (df  =',e12.5,' Hz)'/            
     *     ,15x,'wave number ',7x   ,' (dk  =',e12.5,'   )'/            
     *     ,10x,'output duration'/                                      
     *     ,27x,f7.2,'sec--',f7.2,'sec (',g7.2,' km/s reduced)'/)       
      if(iopt.eq.1) charac= 'integrated  '                              
      if(iopt.eq.2) charac= 'as is       '                              
      if(iopt.eq.3) charac= 'differ.     '                              
      if(ityp.eq.0) type  = 'explosion   '                              
      if(ityp.ge.1) type  = 'dislocation '                              
      write(6,638) charac,type                                          
  638 format(1h //,5x,a12,' of ',a11)                                   
      if(ityp.eq.0) then                                                
          write(6,640)                                                    
 640      format(5x,'Traces correspond to R-, T- and Z-components.'/)
          azm = 0.
      else                                                              
          write(6,641)                                                    
 641      format(5x,'Traces correspond to NS, EW and Z-components.'/)      
          write(6,639) smom,ast,adp,asd                                 
 639      format(10x,'seismic momemt     ',e12.5/                           
     *          ,10x,'strike  from north ',f7.2/                            
     *          ,10x,'dip angle          ',f7.2/                            
     *          ,10x,'slip direction     ',f7.2/)                           
      endif                                                             
C                                                                       
      ast = ast/360.*pi2                                                
      adp = adp/360.*pi2                                                
      asd = asd/360.*pi2
      ssd = sin(asd)                                                    
      csd = cos(asd)                                                    
      sdp = sin(adp)                                                    
      cdp = cos(adp)                                                    
      cdp2= cdp**2-sdp**2                                               
c                                                                       
c   layer effect                                                        
c                                                                       
c*********** F-loop ***********                                         
      do 60 i=1,inpt                                                    
        do 420 kc=1,nc                                                  
            pw(i,kc) = 0.
  420   continue
        fj = i-1                                                        
        rrq = fj/(dauer+dt)                                             
          if(i.lt.iu.or.i.gt.io) go to 60                               
        if(mod(i,10).eq.1) write(6,653) rrq,i                           
  653   format (f12.7,i7)                                               
        frq = cmplx(rrq,-wi/pi2)                                        
        omer = rrq*pi2                                                  
        omeg = cmplx(omer,-wi)                                          
C Futterman model                                                       
        arf = 0.                                                        
        if(rrq .gt. 0.) arf = log(rrq/fref)                             
        do 58 l=1,nol                                                   
          cp(l) = vp(l)                                                 
          cs(l) = vs(l)                                                 
          if(qp(l) .gt. 0.)                                             
     *      cp(l) = vp(l)*(1.+arf/(pi*qp(l))+ai/(2.*qp(l)))             
          if(qs(l). gt. 0.)                                             
     *      cs(l) = vs(l)*(1.+arf/(pi*qs(l))+ai/(2.*qs(l)))             
   58   continue                                                        
        if (omer .eq. 0.) then                                          
          sa = 0.001                                                    
          sb = fo*pi2/blim                                              
        else                                                            
          sa = omer/alim                                                
          sb = omer/blim                                                
        endif                                                           
        nk = (sb-sa)/dk+1                                               
c*********** K-loop ***********                                         
        do 65 j=1,nk                                                    
          sk = sa+(j-1)*dk                                              
          u  = sk/omeg                                                  
          call npsvsh(nol,ns,cp,cs,rho,thn,u,frq,uw)                    
          sk2 = sk*sk                                                   
          va = cp(ns)                                                   
          vb = cs(ns)                                                   
          ro = rho(ns)                                                  
          br  = vb*vb*ro
          if(ityp.eq.0) then
              dl02 = -2.*sk                                                 
              dl04 = -4.*ai*sk2*br
          else
              ak2 = (omeg/va)**2                                            
              bk2 = (omeg/vb)**2                                            
              dl02 = 4.*sk*ak2                                              
              dl24 = (0.,2.)*sk2*br                                         
              dl04 = dl24*(4.*ak2-3.*bk2)                                   
              dl11 = (0.,-2.)*sk*bk2                                        
              dl24 = -dl24*bk2                                              
              ds11 = -2.*bk2                                                
              ds22 = -sk*bk2*br
          endif
c*********** R-loop ***********                                         
          do 430 kr=1,nent                                              
            kc = kr*3 - 3                                               
            rk = sk*r(kr)                                               
c            bj0 = rj0(rk)                                               
c            bj1 = rj1(rk)                                               
            bj0 = besj0(rk)                                               
            bj1 = besj1(rk)                                               
c large argument approx.                                                
c           bj0 = sqrt(1./(pi2*rk)) * exp(-ai*(rk-pi2/8.))              
c           bj1 = sqrt(1./(pi2*rk)) * exp(-ai*(rk-pi2*3./8.))           
            dj0 =-bj1                                                   
            if(ityp .eq. 0) then
                w1 = (uw(2)*dl02+uw(4)*dl04)*dj0/ai                         
                w2 = 0.
                w3 = (uw(6)*dl02+uw(8)*dl04)*bj0
                czm = 1.
                szm = 0.
            else
                bj2 = 2./rk*bj1-bj0                                         
                dj1 = bj0-bj1/rk                                            
                dj2 = bj1-2./rk*bj2                                         
c radiation pattern                                                   
                azm = az(kr)/360.*pi2
                ath = azm - ast
                szm = sin(azm)    
                czm = cos(azm)    
                sth = sin(ath)    
                cth = cos(ath)    
                sth2= 2.*sth*cth
                cth2= cth**2-sth**2
                pv0 = 0.5*ssd*2.*sdp*cdp
                pv1 = csd*cdp*cth-ssd*cdp2*sth
                pv2 = pv0*cth2+csd*sdp*sth2
                sh1 =-csd*cdp*sth-ssd*cdp2*cth
                sh2 =-pv0*2.*sth2+csd*sdp*2.*cth2
c
                w1 = pv0*(uw(2)*dl02+uw(4)*dl04)*dj0/ai                     
     *              +pv1*uw(1 )*dl11*dj1/ai                                  
     *              +pv2*uw(4 )*dl24*dj2/ai                                  
     *              -pv1*uw(9 )*ds11*bj1/r(kr)                               
     *              -pv2*uw(10)*ds22*4.*bj2/r(kr)                            
                w2 = sh1*uw(1 )*dl11*bj1/(ai*rk)                            
     *              +sh2*uw(4 )*dl24*bj2/(ai*rk)                             
     *              -sh1*uw(9 )*ds11*dj1*sk                                  
     *              -sh2*uw(10)*ds22*dj2*sk                                  
c far-field SH only                                                     
c               w2 =                                                        
c    *              -sh1*uw(9 )*ds11*bj0*sk                                  
c    *              -sh2*uw(10)*ds22*bj1*sk                                  
                w3 = pv0*(uw(6)*dl02+uw(8)*dl04)*bj0                        
     *              +pv1*uw(5 )*dl11*bj1                                     
     *              +pv2*uw(8 )*dl24*bj2
            endif
            pw(i,kc+1) = pw(i,kc+1) +(w1*czm-w2*szm)*dk                 
            pw(i,kc+2) = pw(i,kc+2) +(w1*szm+w2*czm)*dk                 
            pw(i,kc+3) = pw(i,kc+3) - w3*dk                             
              if(j.eq.1 .or. j.eq.nk) then                              
                pw(i,kc+1) = pw(i,kc+1) -(w1*czm-w2*szm)*dk/2.          
                pw(i,kc+2) = pw(i,kc+2) -(w1*szm+w2*czm)*dk/2.          
                pw(i,kc+3) = pw(i,kc+3) + w3*dk/2.                      
              endif                                                     
  430     continue                                                      
   65   continue                                                        
        do 440 kc=1,nc                                                  
          kr = (kc+2)/3                                                 
          ks = kc - (kr-1)*3                                            
          pw(i,kc) = pw(i,kc)*s(i,ks)*exp(+ai*omeg*t(kr))              
          if(ityp.ge.1) pw(i,kc) = pw(i,kc)                             
     *                           /(2.*pi2*rho(ns)*omeg*omeg)            
          if(iopt.eq.1) pw(i,kc)=pw(i,kc)/(ai*omeg)                     
          if(iopt.eq.3) pw(i,kc)=pw(i,kc)*(ai*omeg)                     
  440   continue                                                        
   60 continue                                                          
c                                                                       
c   inverse-FFT
c                                                                       
      write(10,654) dt,vred                                             
  654 format (2g12.5)                                                   
      if(icmp .eq. 0) nnc = nc                                          
      if(icmp .gt. 0) nnc = nc/3                                        
      write(10,500) nnc                                                 
      do 70 kc=1,nc                                                     
        kr = (kc+2)/3                                                   
        ks = kc-(kr-1)*3                                                
        if(icmp.ne.0 .and. ks.ne.icmp) go to 70                         
        n1=inpt+1                                                       
        dum(1) = pw(1,kc)                                               
        do 90 k=2,inpt                                                  
          nj  =2*inpt-k+2                                               
          dum(k) = pw(k,kc)                                             
          dum(nj) = conjg(pw(k,kc))                                     
   90   continue                                                        
        dum(n1) = 0.                                                    
        call nlogn(index, dum, 1.0d0)                                       
        do 125 i=1,npts                                                 
  125   pw(i,kc)=dum(i)                                                 
c                                                                       
c   output                                                              
c                                                                       
        amax = 0.
        ndr =(tl-ti)/dt                                                 
        if(npts .lt. ndr)  ndr = npts
        do 130 i=1,ndr                                                  
          tt = dt*float(i-1)                                            
          amw(i)=dble(pw(i,kc))*exp(wi*tt)                              
          ama = abs(amw(i))                                             
          amax=max(amax,ama)                                            
  130   continue                                                        
        write(10,699) r(kr),t(kr)                                       
        write(10,500) ndr                                               
        write(10,698) amax
        if(amax .gt. 0.) then
            do 205 i=1,ndr                                                  
                amw(i)=amw(i)/amax                                            
 205        continue
        endif
        write(10,699) (amw(i),i=1,ndr)                                  
   70 continue                                                          
699   format(6f12.7)                                                    
698   format(e15.7)                                                     
      stop                                                              
      end                                                               
c                                                                       
      subroutine npsvsh(n,ns,a,b,rho,d,u,freq,uw)                       
      implicit complex*16 (a-h,o-z)                                      
      real*8   rho(n),d(n),rec,rep,res                                 
      dimension a(n),b(n),uw(10)                                        
      ns1 = ns + 1                                                      
      pi = 3.14159265e0                                                 
      ai = (0.,1.)                                                      
      omeg = 2.*pi*freq                                                 
      c = 1./u                                                          
      rec = real(c)                                                     
      rk = omeg*u                                                       
      com = c*omeg                                                      
      u2 = u*u                                                          
      c2 = c*c                                                          
      rk2 = rk*rk                                                       
      om2 = omeg*omeg                                                   
c   delta matrix for halfspace (pv)                                     
c   g-matrix     for halfspace (sh)                                     
      s = b(n)                                                          
      p = a(n)                                                          
      rep = real(p)                                                     
      res = real(s)                                                     
      rro = rho(n)                                                      
      s2 = s*s                                                          
      p2 = p*p                                                          
      argp = 1.-c2/p2                                                   
      args = 1.-c2/s2                                                   
        if(rec.gt.rep) cn = rk*sqrt(-argp)                              
        if(rec.le.rep) cn = -rk*sqrt(argp)*ai                           
        if(rec.gt.res) cns = rk*sqrt(-args)                             
        if(rec.le.res) cns = -rk*sqrt(args)*ai                          
      rl = 2.*rk2-om2/s2                                                
      rpp = cn*cns                                                      
      t1 = -s2*s2*rro/(om2+om2)*(4.*rk2*rpp+rl*rl)                      
      t2 = cmplx(0.,0.5)*cn                                             
      t3 = -s2*u/(2.*omeg)*ai*(rl+rpp+rpp)                              
      t4 = cmplx(0.,-0.5)*cns                                           
      t5 = -1./(2.*rro*om2)*(rpp+rk2)                                   
      v1 = (-0.5,0.)                                                    
      v2 = (0.,0.5)/(s2*rro*cns)                                        
        if(ns1.ne.n) go to 900                                          
      th1 = t1                                                          
      th2 = t2                                                          
      th3 = t3                                                          
      th5 = t4                                                          
      th6 = t5                                                          
      vh1 = v1                                                          
      vh2 = v2                                                          
  900 t3 = t3*2.                                                        
c   delta matrix for layers (pv)                                        
c   g-matrix     for layers (sh)                                        
      do 1000 j=2,n                                                     
      i = n-j+1                                                         
      s = b(i)                                                          
      s2 = s*s                                                          
      p = a(i)                                                          
      p2 = p*p                                                          
      rep = real(p)                                                     
      res = real(s)                                                     
      thk = rk*d(i)                                                     
      argp = 1.-c2/p2                                                   
        if(rec.le.rep) go to 190                                        
      ra = sqrt(-argp)                                                  
      p = thk*ra                                                        
      pn = 1.                                                           
      sp = sin(p)                                                       
      cp = cos(p)                                                       
      x = ra*sp                                                         
  180 args = 1.-c2/s2                                                   
        if(rec.le.res) go to 200                                        
      rb = sqrt(-args)                                                  
      q = thk*rb                                                        
      qn = 1.                                                           
      sq = sin(q)                                                       
      cq = cos(q)                                                       
      z = sq*rb                                                         
      go to 210                                                         
  190 ra = -sqrt(argp)                                                  
      p = thk*ra                                                        
      ep = 0.5*exp(p)                                                   
      em = 0.25/ep                                                      
      pn = ep+em                                                        
      sp =(ep-em)/pn                                                    
      cp = 1.                                                           
      x = -sp*ra                                                        
      go to 180                                                         
  200 rb = -sqrt(args)                                                  
      q = thk*rb                                                        
      ep = 0.5*exp(q)                                                   
      em = 0.25/ep                                                      
      qn = ep+em                                                        
      sq =(ep-em)/qn                                                    
      cq = 1.                                                           
      z = -sq*rb                                                        
  210   if(abs(real(p)).lt.1.0e-6) go to 211                            
      w = sp/ra                                                         
      go to 213                                                         
  211 w = thk                                                           
  213   if(abs(real(q)).lt.1.0e-6) go to 212                            
      y = sq/rb                                                         
      go to 214                                                         
  212 y = thk                                                           
  214 continue                                                          
c   delta matrix                                                        
      g1 =-2.*s2*u2                                                     
      g2 = g1+1.                                                        
      e0 = 1./(pn*qn)                                                   
      e1 = cp*cq                                                        
      e2 = e0-e1                                                        
      e3 = w*y                                                          
      e4 = x*z                                                          
      e5 = w*cq                                                         
      e6 = y*cp                                                         
      r1 = com*rho(i)                                                   
      r2 = 1./r1                                                        
      r3 = r1*g1                                                        
      r4 = r1*g2                                                        
      f1 = e2+e3                                                        
      f2 = f1*r2                                                        
      g16 = -r2*(f2+(e2+e4)*r2)                                         
      g13 = -r3*g16+f2                                                  
      f3 = g1*f1+e3                                                     
      f4 = r3*g13+f3                                                    
      g31 = r3*f4+f3*r4                                                 
      g11 = e1-f4                                                       
      g33 = f4+0.5*e0                                                   
      g61 = -r3*g31-r4*(e3*r4+f3*r3)                                    
      g15 = -r2*(e5+z*cp)                                               
      g23 = -r3*g15+e5                                                  
      g21 = -r3*g23-r4*e5                                               
      g12 = r2*(e6+x*cq)                                                
      g32 = -r3*g12-e6                                                  
      g51 = -r3*g32+r4*e6                                               
      g22 = e1                                                          
      g25 = z*w                                                         
      g52 = x*y                                                         
      g13 = g13*ai                                                      
      g31 = g31*ai                                                      
      g23 = g23*ai                                                      
      g32 = g32*ai                                                      
      tr1 = t1*g11+t2*g21+t3*g31+t4*g51+t5*g61                          
      tr2 = t1*g12+t2*g22+t3*g32+t4*g52+t5*g51                          
      tr3 = t1*g13+t2*g23+t3*g33+t4*g32+t5*g31                          
      tr4 = t1*g15+t2*g25+t3*g23+t4*g22+t5*g21                          
      t5  = t1*g16+t2*g15+t3*g13+t4*g12+t5*g11                          
      t1 = tr1                                                          
      t2 = tr2                                                          
      t3 = 2.*tr3                                                       
      t4 = tr4                                                          
      rm = s2*rho(i)                                                    
c   g-matrix (sh)                                                       
      vr1 = v1*cq + v2*(-z*rm*rk)                                       
      v2  = v1*y/(rm*rk) + v2*cq                                        
      v1  = vr1                                                         
      if(i-ns1) 1100,1500,1000                                          
c   g-matrix (pv)                                                       
 1100 cp  = cp/qn                                                       
      w   = w /qn                                                       
      x   = x /qn                                                       
      cq  = cq/pn                                                       
      y   = y /pn                                                       
      z   = z /pn                                                       
      a11 = -g1*cp + g2*cq                                              
      a21 =(-g1*x - g2*y)*ai                                            
      a31 = -r1*g1*g2*(cp-cq)*ai                                        
      a41 = -r3*g1*x - r4*g2*y                                          
      a12 =( g2*w + g1*z)*ai                                            
      a13 =  r2*(cq-cp)*ai                                              
      a14 =  r2*(w+z)                                                   
      a22 =  g2*cp - g1*cq                                              
      a23 =  r2*(x+y)                                                   
      a32 = -r4*g2*w - r3*g1*z                                          
      vh1 = vh1/qn                                                      
      vh2 = vh2/qn                                                      
        if (i.eq.ns) go to 1200                                         
      tr11 = s11*a11+s12*a21+s13*a31+s14*a41                            
      tr21 = s21*a11+s22*a21+s23*a31+s24*a41                            
      tr31 = s31*a11+s32*a21+s33*a31+s34*a41                            
      tr41 = s41*a11+s42*a21+s43*a31+s44*a41                            
      tr12 = s11*a12+s12*a22+s13*a32+s14*a31                            
      tr22 = s21*a12+s22*a22+s23*a32+s24*a31                            
      tr32 = s31*a12+s32*a22+s33*a32+s34*a31                            
      tr42 = s41*a12+s42*a22+s43*a32+s44*a31                            
      tr13 = s11*a13+s12*a23+s13*a22+s14*a21                            
      tr23 = s21*a13+s22*a23+s23*a22+s24*a21                            
      tr33 = s31*a13+s32*a23+s33*a22+s34*a21                            
      tr43 = s41*a13+s42*a23+s43*a22+s44*a21                            
      s14  = s11*a14+s12*a13+s13*a12+s14*a11                            
      s24  = s21*a14+s22*a13+s23*a12+s24*a11                            
      s34  = s31*a14+s32*a13+s33*a12+s34*a11                            
      s44  = s41*a14+s42*a13+s43*a12+s44*a11                            
      s11 = tr11                                                        
      s21 = tr21                                                        
      s31 = tr31                                                        
      s41 = tr41                                                        
      s12 = tr12                                                        
      s22 = tr22                                                        
      s32 = tr32                                                        
      s42 = tr42                                                        
      s13 = tr13                                                        
      s23 = tr23                                                        
      s33 = tr33                                                        
      s43 = tr43                                                        
      go to 1000                                                        
1200  s11 = a11                                                         
      s21 = a21                                                         
      s31 = a31                                                         
      s41 = a41                                                         
      s12 = a12                                                         
      s22 = a22                                                         
      s32 = a32                                                         
      s42 = a31                                                         
      s13 = a13                                                         
      s23 = a23                                                         
      s33 = a22                                                         
      s43 = a21                                                         
      s14 = a14                                                         
      s24 = a13                                                         
      s34 = a12                                                         
      s44 = a11                                                         
      go to 1000                                                        
 1500   th1 = t1                                                        
        th2 = t2                                                        
        th3 = t3/2.                                                     
        th5 = t4                                                        
        th6 = t5                                                        
        vh1 = v1                                                        
        vh2 = v2                                                        
 1000 continue                                                          
      uw(1) = (-s22*th1-s32*th2-s42*th3)/t1                             
      uw(2) = ( s12*th1-s32*th3-s42*th5)/t1                             
      uw(3) = ( s12*th2+s22*th3-s42*th6)/t1                             
      uw(4) = ( s12*th3+s22*th5+s32*th6)/t1                             
      uw(5) = ( s21*th1+s31*th2+s41*th3)/t1                             
      uw(6) = (-s11*th1+s31*th3+s41*th5)/t1                             
      uw(7) = (-s11*th2-s21*th3+s41*th6)/t1                             
      uw(8) = (-s11*th3-s21*th5-s31*th6)/t1                             
      uw(9) = vh1/v1                                                    
      uw(10)= vh2/v1                                                    
      return                                                            
      end                                                               
c                                                                       
c       SIGN must be a double-precision constant (1.d0, -1.d0) or
c       a double-precision variable! (06/25/1999, K2)
c       m(15) --> m(100)             (12/07/2000, K2)
      subroutine nlogn(n,x,sign)                                        
      implicit real*8 (a-h, o-z)
      complex*16 x,wk,hold,q                                            
      dimension m(100),x(2)                                              
      lx=2**n                                                           
      do 1 i=1,n                                                        
1     m(i)=2**(n-i)                                                     
      do 4 l=1,n                                                        
      nblock=2**(l-1)                                                   
      lblock=lx/nblock                                                  
      lbhalf=lblock/2                                                   
      k=0                                                               
      do 4 iblock=1,nblock                                              
      fk=k                                                              
      flx=lx                                                            
      v=sign*6.2831853e0*fk/flx                                         
      wk=cmplx(cos(v),sin(v))                                           
      istart=lblock*(iblock-1)                                          
      do 2 i=1,lbhalf                                                   
      j=istart+i                                                        
      jh=j+lbhalf                                                       
      q=x(jh)*wk                                                        
      x(jh)=x(j)-q                                                      
      x(j)=x(j)+q                                                       
2     continue                                                          
      do 3 i=2,n                                                        
      ii=i                                                              
      if(k.lt.m(i)) go to 4                                             
3     k=k-m(i)                                                          
4     k=k+m(ii)                                                         
      k=0                                                               
      do 7 j=1,lx                                                       
      if(k.lt.j) go to 5                                                
      hold=x(j)                                                         
      x(j)=x(k+1)                                                       
      x(k+1)=hold                                                       
5     do 6 i=1,n                                                        
      ii=i                                                              
      if(k.lt.m(i)) go to 7                                             
6     k=k-m(i)                                                          
7     k=k+m(ii)                                                         
      if(sign.lt.0.0) return                                            
      do 8 i=1,lx                                                       
8     x(i)=x(i)/flx                                                     
      return                                                            
      end                                                               
c                                                                       
      function besj0 (x)
c april 1977 version.  w. fullerton, c3, los alamos scientific lab.
      implicit real*8 (a-h, o-z)
      dimension bj0cs(13), bm0cs(21), bth0cs(24)
c      external cos, csevl, inits, r1mach, sqrt
c
c series for bj0        on the interval  0.          to  1.60000d+01
c                                        with weighted error   7.47e-18
c                                         log weighted error  17.13
c                               significant figures required  16.98
c                                    decimal places required  17.68
c
      data bj0 cs( 1) /    .1002541619 68939137e0 /
      data bj0 cs( 2) /   -.6652230077 64405132e0 /
      data bj0 cs( 3) /    .2489837034 98281314e0 /
      data bj0 cs( 4) /   -.0332527231 700357697e0 /
      data bj0 cs( 5) /    .0023114179 304694015e0 /
      data bj0 cs( 6) /   -.0000991127 741995080e0 /
      data bj0 cs( 7) /    .0000028916 708643998e0 /
      data bj0 cs( 8) /   -.0000000612 108586630e0 /
      data bj0 cs( 9) /    .0000000009 838650793e0 /
      data bj0 cs(10) /   -.0000000000 124235515e0 /
      data bj0 cs(11) /    .0000000000 001265433e0 /
      data bj0 cs(12) /   -.0000000000 000010619e0 /
      data bj0 cs(13) /    .0000000000 000000074e0 /
c
c series for bm0        on the interval  0.          to  6.25000d-02
c                                        with weighted error   4.98e-17
c                                         log weighted error  16.30
c                               significant figures required  14.97
c                                    decimal places required  16.96
c
      data bm0 cs( 1) /    .0928496163 7381644e0 /
      data bm0 cs( 2) /   -.0014298770 7403484e0 /
      data bm0 cs( 3) /    .0000283057 9271257e0 /
      data bm0 cs( 4) /   -.0000014330 0611424e0 /
      data bm0 cs( 5) /    .0000001202 8628046e0 /
      data bm0 cs( 6) /   -.0000000139 7113013e0 /
      data bm0 cs( 7) /    .0000000020 4076188e0 /
      data bm0 cs( 8) /   -.0000000003 5399669e0 /
      data bm0 cs( 9) /    .0000000000 7024759e0 /
      data bm0 cs(10) /   -.0000000000 1554107e0 /
      data bm0 cs(11) /    .0000000000 0376226e0 /
      data bm0 cs(12) /   -.0000000000 0098282e0 /
      data bm0 cs(13) /    .0000000000 0027408e0 /
      data bm0 cs(14) /   -.0000000000 0008091e0 /
      data bm0 cs(15) /    .0000000000 0002511e0 /
      data bm0 cs(16) /   -.0000000000 0000814e0 /
      data bm0 cs(17) /    .0000000000 0000275e0 /
      data bm0 cs(18) /   -.0000000000 0000096e0 /
      data bm0 cs(19) /    .0000000000 0000034e0 /
      data bm0 cs(20) /   -.0000000000 0000012e0 /
      data bm0 cs(21) /    .0000000000 0000004e0 /
c
c series for bth0       on the interval  0.          to  6.25000d-02
c                                        with weighted error   3.67e-17
c                                         log weighted error  16.44
c                               significant figures required  15.53
c                                    decimal places required  17.13
c
      data bth0cs( 1) /   -.2463916377 4300119e0 /
      data bth0cs( 2) /    .0017370983 07508963e0 /
      data bth0cs( 3) /   -.0000621836 33402968e0 /
      data bth0cs( 4) /    .0000043680 50165742e0 /
      data bth0cs( 5) /   -.0000004560 93019869e0 /
      data bth0cs( 6) /    .0000000621 97400101e0 /
      data bth0cs( 7) /   -.0000000103 00442889e0 /
      data bth0cs( 8) /    .0000000019 79526776e0 /
      data bth0cs( 9) /   -.0000000004 28198396e0 /
      data bth0cs(10) /    .0000000001 02035840e0 /
      data bth0cs(11) /   -.0000000000 26363898e0 /
      data bth0cs(12) /    .0000000000 07297935e0 /
      data bth0cs(13) /   -.0000000000 02144188e0 /
      data bth0cs(14) /    .0000000000 00663693e0 /
      data bth0cs(15) /   -.0000000000 00215126e0 /
      data bth0cs(16) /    .0000000000 00072659e0 /
      data bth0cs(17) /   -.0000000000 00025465e0 /
      data bth0cs(18) /    .0000000000 00009229e0 /
      data bth0cs(19) /   -.0000000000 00003448e0 /
      data bth0cs(20) /    .0000000000 00001325e0 /
      data bth0cs(21) /   -.0000000000 00000522e0 /
      data bth0cs(22) /    .0000000000 00000210e0 /
      data bth0cs(23) /   -.0000000000 00000087e0 /
      data bth0cs(24) /    .0000000000 00000036e0 /
c
      data pi4 / 0.7853981633 9744831e0 /
      data ntj0, ntm0, ntth0, xsml, xmax / 3*0, 2*0./
c
      if (ntj0.ne.0) go to 10
c      ntj0 = inits (bj0cs, 13, 0.1*r1mach(3))
c      ntm0 = inits (bm0cs, 21, 0.1*r1mach(3))
c      ntth0 = inits (bth0cs, 24, 0.1*r1mach(3))
      ntj0 = inits (bj0cs, 13, 0.1*d1mach(3))
      ntm0 = inits (bm0cs, 21, 0.1*d1mach(3))
      ntth0 = inits (bth0cs, 24, 0.1*d1mach(3))
c
c      xsml = sqrt (4.0*r1mach(3))
c      xmax = 1.0/r1mach(4)
      xsml = sqrt (4.0*d1mach(3))
      xmax = 1.0/d1mach(4)
c
 10   y = abs(x)
      if (y.gt.4.0) go to 20
c
      besj0 = 1.0
      if (y.gt.xsml) besj0 = csevl (.125*y*y-1., bj0cs, ntj0)
      return
c
 20   if (y.gt.xmax) call seteru (
     1  'besj0   no precision because abs(x) is big', 42, 1, 2)
c
      z = 32.0/y**2 - 1.0
      ampl = (0.75 + csevl (z, bm0cs, ntm0)) / sqrt(y)
      theta = y - pi4 + csevl (z, bth0cs, ntth0) / y
      besj0 = ampl * cos (theta)
c
      return
      end
c
      function besj1 (x)
c sept 1983 edition.  w. fullerton, c3, los alamos scientific lab.
      implicit real*8 (a-h, o-z)
      dimension bj1cs(12), bm1cs(21), bth1cs(24)
c      external cos, csevl, inits, r1mach, sqrt
c
c series for bj1        on the interval  0.          to  1.60000d+01
c                                        with weighted error   4.48e-17
c                                         log weighted error  16.35
c                               significant figures required  15.77
c                                    decimal places required  16.89
c
      data bj1 cs( 1) /   -.1172614151 3332787e0 /
      data bj1 cs( 2) /   -.2536152183 0790640e0 /
      data bj1 cs( 3) /    .0501270809 84469569e0 /
      data bj1 cs( 4) /   -.0046315148 09625081e0 /
      data bj1 cs( 5) /    .0002479962 29415914e0 /
      data bj1 cs( 6) /   -.0000086789 48686278e0 /
      data bj1 cs( 7) /    .0000002142 93917143e0 /
      data bj1 cs( 8) /   -.0000000039 36093079e0 /
      data bj1 cs( 9) /    .0000000000 55911823e0 /
      data bj1 cs(10) /   -.0000000000 00632761e0 /
      data bj1 cs(11) /    .0000000000 00005840e0 /
      data bj1 cs(12) /   -.0000000000 00000044e0 /
c
c series for bm1        on the interval  0.          to  6.25000d-02
c                                        with weighted error   5.61e-17
c                                         log weighted error  16.25
c                               significant figures required  14.97
c                                    decimal places required  16.91
c
      data bm1 cs( 1) /    .1047362510 931285e0 /
      data bm1 cs( 2) /    .0044244389 3702345e0 /
      data bm1 cs( 3) /   -.0000566163 9504035e0 /
      data bm1 cs( 4) /    .0000023134 9417339e0 /
      data bm1 cs( 5) /   -.0000001737 7182007e0 /
      data bm1 cs( 6) /    .0000000189 3209930e0 /
      data bm1 cs( 7) /   -.0000000026 5416023e0 /
      data bm1 cs( 8) /    .0000000004 4740209e0 /
      data bm1 cs( 9) /   -.0000000000 8691795e0 /
      data bm1 cs(10) /    .0000000000 1891492e0 /
      data bm1 cs(11) /   -.0000000000 0451884e0 /
      data bm1 cs(12) /    .0000000000 0116765e0 /
      data bm1 cs(13) /   -.0000000000 0032265e0 /
      data bm1 cs(14) /    .0000000000 0009450e0 /
      data bm1 cs(15) /   -.0000000000 0002913e0 /
      data bm1 cs(16) /    .0000000000 0000939e0 /
      data bm1 cs(17) /   -.0000000000 0000315e0 /
      data bm1 cs(18) /    .0000000000 0000109e0 /
      data bm1 cs(19) /   -.0000000000 0000039e0 /
      data bm1 cs(20) /    .0000000000 0000014e0 /
      data bm1 cs(21) /   -.0000000000 0000005e0 /
c
c series for bth1       on the interval  0.          to  6.25000d-02
c                                        with weighted error   4.10e-17
c                                         log weighted error  16.39
c                               significant figures required  15.96
c                                    decimal places required  17.08
c
      data bth1cs( 1) /    .7406014102 6313850e0 /
      data bth1cs( 2) /   -.0045717556 59637690e0 /
      data bth1cs( 3) /    .0001198185 10964326e0 /
      data bth1cs( 4) /   -.0000069645 61891648e0 /
      data bth1cs( 5) /    .0000006554 95621447e0 /
      data bth1cs( 6) /   -.0000000840 66228945e0 /
      data bth1cs( 7) /    .0000000133 76886564e0 /
      data bth1cs( 8) /   -.0000000024 99565654e0 /
      data bth1cs( 9) /    .0000000005 29495100e0 /
      data bth1cs(10) /   -.0000000001 24135944e0 /
      data bth1cs(11) /    .0000000000 31656485e0 /
      data bth1cs(12) /   -.0000000000 08668640e0 /
      data bth1cs(13) /    .0000000000 02523758e0 /
      data bth1cs(14) /   -.0000000000 00775085e0 /
      data bth1cs(15) /    .0000000000 00249527e0 /
      data bth1cs(16) /   -.0000000000 00083773e0 /
      data bth1cs(17) /    .0000000000 00029205e0 /
      data bth1cs(18) /   -.0000000000 00010534e0 /
      data bth1cs(19) /    .0000000000 00003919e0 /
      data bth1cs(20) /   -.0000000000 00001500e0 /
      data bth1cs(21) /    .0000000000 00000589e0 /
      data bth1cs(22) /   -.0000000000 00000237e0 /
      data bth1cs(23) /    .0000000000 00000097e0 /
      data bth1cs(24) /   -.0000000000 00000040e0 /
c
c
      data pi4 / 0.7853981633 9744831e0 /
      data ntj1, ntm1, ntth1, xsml, xmin, xmax / 3*0, 3*0./
c
      if (ntj1.ne.0) go to 10
c      ntj1 = inits (bj1cs, 12, 0.1*r1mach(3))
c      ntm1 = inits (bm1cs, 21, 0.1*r1mach(3))
c      ntth1 = inits (bth1cs, 24, 0.1*r1mach(3))
      ntj1 = inits (bj1cs, 12, 0.1*d1mach(3))
      ntm1 = inits (bm1cs, 21, 0.1*d1mach(3))
      ntth1 = inits (bth1cs, 24, 0.1*d1mach(3))
c
c      xsml = sqrt (8.0*r1mach(3))
c      xmin = 2.0*r1mach(1)
c      xmax = 1.0/r1mach(4)
      xsml = sqrt (8.0*d1mach(3))
      xmin = 2.0*d1mach(1)
      xmax = 1.0/d1mach(4)
c
 10   y = abs(x)
      if (y.gt.4.0) go to 20
c
      besj1 = 0.0
      if (y.eq.0.0) return
      if (y.le.xmin) call seteru (
     1  'besj1   abs(x) so small j1 underflows', 37, 1, 0)
      if (y.gt.xmin) besj1 = 0.5*x
      if (y.gt.xsml) besj1 = x * (.25 + csevl(.125*y*y-1., bj1cs, ntj1))
      return
c
 20   if (y.gt.xmax) call seteru (
     1  'besj1   no precision because abs(x) is big', 42, 2, 2)
      z = 32.0/y**2 - 1.0
      ampl = (0.75 + csevl (z, bm1cs, ntm1)) / sqrt(y)
      theta = y - 3.0*pi4 + csevl (z, bth1cs, ntth1) / y
      besj1 = sign (ampl, x) * cos (theta)
c
      return
      end
c
      function csevl (x, cs, n)
c april 1977 version.  w. fullerton, c3, los alamos scientific lab.
c
c evaluate the n-term chebyshev series cs at x.  adapted from
c r. broucke, algorithm 446, c.a.c.m., 16, 254 (1973).  also see fox
c and parker, chebyshev polys in numerical analysis, oxford press, p.56.
c
c             input arguments --
c x      value at which the series is to be evaluated.
c cs     array of n terms of a chebyshev series.  in eval-
c        uating cs, only half the first coef is summed.
c n      number of terms in array cs.
c
      implicit real*8 (a-h, o-z)
      dimension cs(1)
c
      if (n.lt.1) call seteru ('csevl   number of terms le 0', 28, 2,2)
      if (n.gt.1000) call seteru ('csevl   number of terms gt 1000',
     1  31, 3, 2)
      if (x.lt.(-1.1) .or. x.gt.1.1) call seteru (
     1  'csevl   x outside (-1,+1)', 25, 1, 1)
c
      b1 = 0.
      b0 = 0.
      twox = 2.*x
      do 10 i=1,n
        b2 = b1
        b1 = b0
        ni = n + 1 - i
        b0 = twox*b1 - b2 + cs(ni)
 10   continue
c
      csevl = 0.5 * (b0-b2)
c
      return
      end
c
      subroutine seteru (messg, nmessg, nerr, iopt)
      implicit real*8 (a-h, o-z)
      common /cseter/ iunflo
c      integer messg(1)
      character*1 messg(nmessg)
      data iunflo / 0 /
c
c      if (iopt.ne.0) call seterr (messg, nmessg, nerr, iopt)
      if (iopt.ne.0) write(*,'(50a1)') (messg(i),i=1,nmessg)
      if (iopt.ne.0) return
c
      if (iunflo.le.0) return
c      call seterr (messg, nmessg, nerr, 1)
      write(*,'(50a1)') (messg(i),i=1,nmessg)
c
      return
      end
c
      function inits (os, nos, eta)
c april 1977 version.  w. fullerton, c3, los alamos scientific lab.
c
c initialize the orthogonal series so that inits is the number of terms
c needed to insure the error is no larger than eta.  ordinarily, eta
c will be chosen to be one-tenth machine precision.
c
c             input arguments --
c os     array of nos coefficients in an orthogonal series.
c nos    number of coefficients in os.
c eta    requested accuracy of series.
c
      implicit real*8 (a-h, o-z)
      dimension os(nos)
c
      if (nos.lt.1) call seteru (
     1  'inits   number of coefficients lt 1', 35, 2, 2)
c
      err = 0.
      do 10 ii=1,nos
        i = nos + 1 - ii
        err = err + abs(os(i))
        if (err.gt.eta) go to 20
 10   continue
c
 20   if (i.eq.nos) call seteru ('inits   eta may be too small', 28,
     1  1, 2)
      inits = i
c
      return
      end
